/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.util.Iterator;
import org.opencds.cqf.cql.engine.elm.executing.LessEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.State;

public class MinEvaluator {
    public static Object min(Object source, State state) {
        if (source == null) {
            return null;
        }
        if (source instanceof Iterable) {
            Iterable element = (Iterable)source;
            Iterator itr = element.iterator();
            if (!itr.hasNext()) {
                return null;
            }
            Object min = itr.next();
            while (min == null && itr.hasNext()) {
                min = itr.next();
            }
            while (itr.hasNext()) {
                Boolean less;
                Object value = itr.next();
                if (value == null || (less = LessEvaluator.less(value, min, state)) == null || !less.booleanValue()) continue;
                min = value;
            }
            return min;
        }
        throw new InvalidOperatorArgument("Min(List<Integer>), Min(List<Long>), Min(List<Decimal>), Min(List<Quantity>), Min(List<Date>), Min(List<DateTime>), Min(List<Time>) or Min(List<String>)", String.format("Min(%s)", source.getClass().getName()));
    }
}

