/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.math.BigDecimal;
import javax.xml.namespace.QName;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.State;
import org.opencds.cqf.cql.engine.runtime.Date;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Quantity;
import org.opencds.cqf.cql.engine.runtime.Time;
import org.opencds.cqf.cql.engine.runtime.Value;

public class MaxValueEvaluator {
    public static Object maxValue(String type) {
        if (type == null) {
            return null;
        }
        if (type.endsWith("Integer")) {
            return Value.MAX_INT;
        }
        if (type.endsWith("Long")) {
            return Value.MAX_LONG;
        }
        if (type.endsWith("Decimal")) {
            return Value.MAX_DECIMAL;
        }
        if (type.endsWith("Date")) {
            return new Date(9999, 12, 31);
        }
        if (type.endsWith("DateTime")) {
            return new DateTime(BigDecimal.ZERO, 9999, 12, 31, 23, 59, 59, 999);
        }
        if (type.endsWith("Time")) {
            return new Time(23, 59, 59, 999);
        }
        if (type.endsWith("Quantity")) {
            return new Quantity().withValue(Value.MAX_DECIMAL).withUnit("1");
        }
        throw new InvalidOperatorArgument(String.format("The Maximum operator is not implemented for type %s", type));
    }

    public static Object internalEvaluate(QName typeName, State state) {
        QName valueType = state.getEnvironment().fixupQName(typeName);
        String type = valueType.getLocalPart();
        return MaxValueEvaluator.maxValue(type);
    }
}

