/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.State;
import org.opencds.cqf.cql.engine.runtime.Code;
import org.opencds.cqf.cql.engine.runtime.CodeSystem;
import org.opencds.cqf.cql.engine.runtime.Concept;
import org.opencds.cqf.cql.engine.terminology.CodeSystemInfo;
import org.opencds.cqf.cql.engine.terminology.TerminologyProvider;

public class InCodeSystemEvaluator {
    public static Object inCodeSystem(Object code, Object codeSystem, State state) {
        if (code == null || codeSystem == null) {
            return null;
        }
        if (codeSystem instanceof CodeSystem) {
            CodeSystemInfo csi = CodeSystemInfo.fromCodeSystem((CodeSystem)codeSystem);
            TerminologyProvider provider = state.getEnvironment().getTerminologyProvider();
            if (code instanceof String) {
                return provider.lookup(new Code().withCode((String)code), csi) != null;
            }
            if (code instanceof Code) {
                return provider.lookup((Code)code, csi) != null;
            }
            if (code instanceof Concept) {
                for (Code codes : ((Concept)code).getCodes()) {
                    if (provider.lookup(codes, csi) == null) continue;
                    return true;
                }
                return false;
            }
        }
        throw new InvalidOperatorArgument("In(String, CodeSystemRef), In(Code, CodeSystemRef) or In(Concept, CodeSystemRef)", String.format("In(%s, %s)", code.getClass().getName(), codeSystem.getClass().getName()));
    }
}

