/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.opencds.cqf.cql.engine.elm.executing.CountEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.DivideEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.PowerEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ProductEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.ToDecimalEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.State;

public class GeometricMeanEvaluator {
    public static BigDecimal geometricMean(Iterable<?> source, State state) {
        if (source == null) {
            return null;
        }
        ArrayList<BigDecimal> cleanSource = new ArrayList<BigDecimal>();
        for (Object element : source) {
            if (element == null) continue;
            if (element instanceof BigDecimal) {
                cleanSource.add((BigDecimal)element);
                continue;
            }
            throw new InvalidOperatorArgument("GeometricMean(List<Decimal>)", String.format("GeometricMean(%s)", element.getClass().getName()));
        }
        return (BigDecimal)PowerEvaluator.power(ProductEvaluator.product(cleanSource), DivideEvaluator.divide(new BigDecimal(1), ToDecimalEvaluator.toDecimal(CountEvaluator.count(cleanSource)), state));
    }
}

