/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Date;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.runtime.Precision;
import org.opencds.cqf.cql.engine.runtime.Time;

public class DurationBetweenEvaluator {
    public static Object duration(Object left, Object right, Precision precision) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof BaseTemporal && right instanceof BaseTemporal) {
            boolean isWeeks = false;
            if (precision == Precision.WEEK) {
                isWeeks = true;
                precision = Precision.DAY;
            }
            boolean isLeftUncertain = ((BaseTemporal)left).isUncertain(precision);
            boolean isRightUncertain = ((BaseTemporal)right).isUncertain(precision);
            if (isLeftUncertain && isRightUncertain) {
                return null;
            }
            if (isLeftUncertain) {
                Interval leftUncertainInterval = ((BaseTemporal)left).getUncertaintyInterval(precision);
                return new Interval(DurationBetweenEvaluator.duration(leftUncertainInterval.getEnd(), right, isWeeks ? Precision.WEEK : precision), true, DurationBetweenEvaluator.duration(leftUncertainInterval.getStart(), right, isWeeks ? Precision.WEEK : precision), true).setUncertain(true);
            }
            if (isRightUncertain) {
                Interval rightUncertainInterval = ((BaseTemporal)right).getUncertaintyInterval(precision);
                return new Interval(DurationBetweenEvaluator.duration(left, rightUncertainInterval.getStart(), isWeeks ? Precision.WEEK : precision), true, DurationBetweenEvaluator.duration(left, rightUncertainInterval.getEnd(), isWeeks ? Precision.WEEK : precision), true).setUncertain(true);
            }
            if (left instanceof DateTime && right instanceof DateTime) {
                if (precision.toDateTimeIndex() <= Precision.DAY.toDateTimeIndex()) {
                    return isWeeks ? (int)precision.toChronoUnit().between(((DateTime)left).getDateTime().toLocalDateTime(), ((DateTime)right).getDateTime().toLocalDateTime()) / 7 : (int)precision.toChronoUnit().between(((DateTime)left).getDateTime().toLocalDateTime(), ((DateTime)right).getDateTime().toLocalDateTime());
                }
                return (int)precision.toChronoUnit().between(((DateTime)left).getDateTime(), ((DateTime)right).getDateTime());
            }
            if (left instanceof Date && right instanceof Date) {
                return isWeeks ? (int)precision.toChronoUnit().between(((Date)left).getDate(), ((Date)right).getDate()) / 7 : (int)precision.toChronoUnit().between(((Date)left).getDate(), ((Date)right).getDate());
            }
            if (left instanceof Time && right instanceof Time) {
                return (int)precision.toChronoUnit().between(((Time)left).getTime(), ((Time)right).getTime());
            }
        }
        throw new InvalidOperatorArgument("DurationBetween(Date, Date), DurationBetween(DateTime, DateTime), DurationBetween(Time, Time)", String.format("DurationBetween(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }
}

