/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.math.BigDecimal;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.runtime.Quantity;

public class CeilingEvaluator {
    public static Object ceiling(Object operand) {
        if (operand == null) {
            return null;
        }
        if (operand instanceof BigDecimal) {
            return BigDecimal.valueOf(Math.ceil(((BigDecimal)operand).doubleValue())).intValue();
        }
        if (operand instanceof Quantity) {
            return BigDecimal.valueOf(Math.ceil(((Quantity)operand).getValue().doubleValue())).intValue();
        }
        throw new InvalidOperatorArgument("Ceiling(Decimal)", String.format("Ceiling(%s)", operand.getClass().getName()));
    }
}

