/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import org.cqframework.cql.cql2elm.CqlTranslatorOptions;
import org.hl7.cql_annotations.r1.CqlToElmBase;
import org.hl7.cql_annotations.r1.CqlToElmInfo;
import org.hl7.elm.r1.Library;

public class TranslatorOptionsUtil {
    public static EnumSet<CqlTranslatorOptions.Options> getTranslatorOptions(Library library) {
        Objects.requireNonNull(library, "library can not be null");
        if (library.getAnnotation() == null || library.getAnnotation().isEmpty()) {
            return null;
        }
        String translatorOptions = TranslatorOptionsUtil.getTranslatorOptions(library.getAnnotation());
        return TranslatorOptionsUtil.parseTranslatorOptions(translatorOptions);
    }

    private static String getTranslatorOptions(List<CqlToElmBase> annotations) {
        for (CqlToElmBase base : annotations) {
            if (!(base instanceof CqlToElmInfo) || ((CqlToElmInfo)base).getTranslatorOptions() == null) continue;
            return ((CqlToElmInfo)base).getTranslatorOptions();
        }
        return null;
    }

    public static EnumSet<CqlTranslatorOptions.Options> parseTranslatorOptions(String translatorOptions) {
        String[] options;
        if (translatorOptions == null || translatorOptions.isEmpty()) {
            return null;
        }
        EnumSet<CqlTranslatorOptions.Options> optionSet = EnumSet.noneOf(CqlTranslatorOptions.Options.class);
        for (String option : options = translatorOptions.trim().split(",")) {
            optionSet.add(CqlTranslatorOptions.Options.valueOf(option));
        }
        return optionSet;
    }
}

