/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.cqframework.cql.cql2elm.CqlCompilerException;

public class LibraryReaderUtil {
    public static Source toSource(Object json) throws IOException {
        if (json == null) {
            throw new CqlCompilerException("no JSON is given");
        }
        if (json instanceof String) {
            try {
                json = new URI((String)json);
            }
            catch (URISyntaxException e) {
                json = new File((String)json);
            }
        }
        if (json instanceof File) {
            return new StreamSource((File)json);
        }
        if (json instanceof URI) {
            json = ((URI)json).toURL();
        }
        if (json instanceof URL) {
            return new StreamSource(((URL)json).toExternalForm());
        }
        if (json instanceof InputStream) {
            return new StreamSource((InputStream)json);
        }
        if (json instanceof Reader) {
            return new StreamSource((Reader)json);
        }
        if (json instanceof Source) {
            return (Source)json;
        }
        throw new CqlCompilerException(String.format("Could not determine access path for input of type %s.", json.getClass()));
    }
}

