/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import org.cqframework.cql.cql2elm.PathAware;
import org.cqframework.cql.cql2elm.model.Version;
import org.hl7.cql.model.ModelIdentifier;
import org.hl7.cql.model.ModelInfoProvider;
import org.hl7.elm_modelinfo.r1.ModelInfo;
import org.hl7.elm_modelinfo.r1.serializing.ModelInfoReaderFactory;

public class DefaultModelInfoProvider
implements ModelInfoProvider,
PathAware {
    private Path path;

    public DefaultModelInfoProvider() {
    }

    public DefaultModelInfoProvider(Path path) {
        this.setPath(path);
    }

    @Override
    public void setPath(Path path) {
        if (path == null || !path.toFile().isDirectory()) {
            throw new IllegalArgumentException(String.format("path '%s' is not a valid directory", path));
        }
        this.path = path;
    }

    private void checkPath() {
        if (this.path == null || this.path.equals("")) {
            throw new IllegalArgumentException("Path is required for DefaultModelInfoProvider implementation");
        }
    }

    public ModelInfo load(ModelIdentifier modelIdentifier) {
        if (this.path != null) {
            final String modelName = modelIdentifier.getId();
            String modelVersion = modelIdentifier.getVersion();
            Path modelPath = this.path.resolve(String.format("%s-modelinfo%s.xml", modelName.toLowerCase(), modelVersion != null ? "-" + modelVersion : ""));
            File modelFile = modelPath.toFile();
            if (!modelFile.exists()) {
                FilenameFilter filter = new FilenameFilter(){

                    @Override
                    public boolean accept(File path, String name) {
                        return name.startsWith(modelName.toLowerCase() + "-modelinfo") && name.endsWith(".xml");
                    }
                };
                File mostRecentFile = null;
                Version mostRecent = null;
                try {
                    Version requestedVersion = modelVersion == null ? null : new Version(modelVersion);
                    for (File file : this.path.toFile().listFiles(filter)) {
                        String[] fileNameComponents;
                        String fileName = file.getName();
                        int indexOfExtension = fileName.lastIndexOf(".");
                        if (indexOfExtension >= 0) {
                            fileName = fileName.substring(0, indexOfExtension);
                        }
                        if ((fileNameComponents = fileName.split("-")).length == 3) {
                            Version version = new Version(fileNameComponents[2]);
                            if (requestedVersion != null && !version.compatibleWith(requestedVersion)) continue;
                            if (mostRecent == null || version != null && version.isComparable() && mostRecent != null && mostRecent.isComparable() && version.compareTo(mostRecent) > 0) {
                                mostRecent = version;
                                mostRecentFile = file;
                                continue;
                            }
                            if (version == null || !version.matchStrictly(mostRecent)) continue;
                            mostRecent = version;
                            mostRecentFile = file;
                            continue;
                        }
                        if (mostRecent != null) continue;
                        mostRecentFile = file;
                    }
                    modelFile = mostRecentFile;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            try {
                if (modelFile != null) {
                    FileInputStream is = new FileInputStream(modelFile);
                    return ModelInfoReaderFactory.getReader((String)"application/xml").read((InputStream)is);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalArgumentException(String.format("Could not load definition for model info %s.", modelIdentifier.getId()), e);
            }
        }
        return null;
    }
}

