/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.cqframework.cql.cql2elm.Cql2ElmVisitor;
import org.cqframework.cql.cql2elm.CqlCompilerException;
import org.cqframework.cql.cql2elm.CqlSyntaxException;
import org.cqframework.cql.cql2elm.CqlTranslatorOptions;
import org.cqframework.cql.cql2elm.LibraryBuilder;
import org.cqframework.cql.cql2elm.LibraryManager;
import org.cqframework.cql.cql2elm.ModelManager;
import org.cqframework.cql.cql2elm.StringEscapeUtils;
import org.cqframework.cql.cql2elm.model.CompiledLibrary;
import org.cqframework.cql.cql2elm.preprocessor.CqlPreprocessorVisitor;
import org.cqframework.cql.elm.tracking.TrackBack;
import org.cqframework.cql.gen.cqlLexer;
import org.cqframework.cql.gen.cqlParser;
import org.fhir.ucum.UcumService;
import org.hl7.cql.model.NamespaceAware;
import org.hl7.cql.model.NamespaceInfo;
import org.hl7.elm.r1.Library;
import org.hl7.elm.r1.Retrieve;
import org.hl7.elm.r1.VersionedIdentifier;

public class CqlCompiler {
    private Library library = null;
    private CompiledLibrary compiledLibrary = null;
    private Object visitResult = null;
    private List<Retrieve> retrieves = null;
    private List<CqlCompilerException> exceptions = null;
    private List<CqlCompilerException> errors = null;
    private List<CqlCompilerException> warnings = null;
    private List<CqlCompilerException> messages = null;
    private VersionedIdentifier sourceInfo = null;
    private NamespaceInfo namespaceInfo = null;
    private ModelManager modelManager = null;
    private LibraryManager libraryManager = null;
    private UcumService ucumService = null;

    public CqlCompiler(ModelManager modelManager, LibraryManager libraryManager) {
        this(null, null, modelManager, libraryManager, null);
    }

    public CqlCompiler(NamespaceInfo namespaceInfo, ModelManager modelManager, LibraryManager libraryManager) {
        this(namespaceInfo, null, modelManager, libraryManager, null);
    }

    public CqlCompiler(NamespaceInfo namespaceInfo, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService) {
        this(namespaceInfo, null, modelManager, libraryManager, ucumService);
    }

    public CqlCompiler(NamespaceInfo namespaceInfo, VersionedIdentifier sourceInfo, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService) {
        this.sourceInfo = sourceInfo;
        this.namespaceInfo = namespaceInfo;
        this.modelManager = modelManager;
        this.libraryManager = libraryManager;
        this.ucumService = ucumService;
        if (this.sourceInfo == null) {
            this.sourceInfo = new VersionedIdentifier().withId("Anonymous").withSystem("text/cql");
        }
        if (this.namespaceInfo != null) {
            modelManager.getNamespaceManager().ensureNamespaceRegistered(this.namespaceInfo);
            libraryManager.getNamespaceManager().ensureNamespaceRegistered(this.namespaceInfo);
        }
        if (libraryManager.getNamespaceManager().hasNamespaces() && libraryManager.getLibrarySourceLoader() instanceof NamespaceAware) {
            ((NamespaceAware)libraryManager.getLibrarySourceLoader()).setNamespaceManager(libraryManager.getNamespaceManager());
        }
        if (libraryManager.getUcumService() == null) {
            libraryManager.setUcumService(this.ucumService);
        }
    }

    public Library getLibrary() {
        return this.library;
    }

    public CompiledLibrary getCompiledLibrary() {
        return this.compiledLibrary;
    }

    public Object toObject() {
        return this.visitResult;
    }

    public List<Retrieve> toRetrieves() {
        return this.retrieves;
    }

    public Map<String, CompiledLibrary> getCompiledLibraries() {
        return this.libraryManager.getCompiledLibraries();
    }

    public Map<String, Library> getLibraries() {
        HashMap<String, Library> result = new HashMap<String, Library>();
        for (String libraryName : this.libraryManager.getCompiledLibraries().keySet()) {
            result.put(libraryName, this.libraryManager.getCompiledLibraries().get(libraryName).getLibrary());
        }
        return result;
    }

    public List<CqlCompilerException> getExceptions() {
        return this.exceptions;
    }

    public List<CqlCompilerException> getErrors() {
        return this.errors;
    }

    public List<CqlCompilerException> getWarnings() {
        return this.warnings;
    }

    public List<CqlCompilerException> getMessages() {
        return this.messages;
    }

    public Library run(String cqlText, CqlTranslatorOptions.Options ... options) throws IOException {
        return this.run((CharStream)CharStreams.fromString((String)cqlText), new CqlTranslatorOptions(options));
    }

    public Library run(String cqlText, CqlCompilerException.ErrorSeverity errorLevel, CqlTranslatorOptions.Options ... options) throws IOException {
        return this.run((CharStream)CharStreams.fromString((String)cqlText), new CqlTranslatorOptions(errorLevel, options));
    }

    public Library run(String cqlText, CqlCompilerException.ErrorSeverity errorLevel, LibraryBuilder.SignatureLevel signatureLevel, CqlTranslatorOptions.Options ... options) throws IOException {
        return this.run((CharStream)CharStreams.fromString((String)cqlText), new CqlTranslatorOptions(errorLevel, signatureLevel, options));
    }

    public Library run(InputStream is, CqlTranslatorOptions.Options ... options) throws IOException {
        return this.run(CharStreams.fromStream((InputStream)is), new CqlTranslatorOptions(options));
    }

    public Library run(InputStream is, CqlCompilerException.ErrorSeverity errorLevel, CqlTranslatorOptions.Options ... options) throws IOException {
        return this.run(CharStreams.fromStream((InputStream)is), new CqlTranslatorOptions(errorLevel, options));
    }

    public Library run(InputStream is, CqlCompilerException.ErrorSeverity errorLevel, LibraryBuilder.SignatureLevel signatureLevel, CqlTranslatorOptions.Options ... options) throws IOException {
        return this.run(CharStreams.fromStream((InputStream)is), new CqlTranslatorOptions(errorLevel, signatureLevel, options));
    }

    public Library run(CharStream is, CqlTranslatorOptions.Options ... options) {
        return this.run(is, new CqlTranslatorOptions(options));
    }

    public Library run(CharStream is, CqlCompilerException.ErrorSeverity errorLevel, CqlTranslatorOptions.Options ... options) {
        return this.run(is, new CqlTranslatorOptions(errorLevel, LibraryBuilder.SignatureLevel.None, options));
    }

    public Library run(CharStream is, CqlCompilerException.ErrorSeverity errorLevel, LibraryBuilder.SignatureLevel signatureLevel, CqlTranslatorOptions.Options ... options) {
        return this.run(is, new CqlTranslatorOptions(errorLevel, signatureLevel, options));
    }

    public Library run(InputStream is, CqlTranslatorOptions options) throws IOException {
        return this.run(CharStreams.fromStream((InputStream)is), options);
    }

    public Library run(CharStream is, CqlTranslatorOptions options) {
        this.exceptions = new ArrayList<CqlCompilerException>();
        this.errors = new ArrayList<CqlCompilerException>();
        this.warnings = new ArrayList<CqlCompilerException>();
        this.messages = new ArrayList<CqlCompilerException>();
        LibraryBuilder builder = new LibraryBuilder(this.namespaceInfo, this.modelManager, this.libraryManager, this.ucumService);
        builder.setTranslatorOptions(options);
        Cql2ElmVisitor visitor = new Cql2ElmVisitor(builder);
        builder.setVisitor(visitor);
        visitor.setTranslatorOptions(options);
        CqlErrorListener errorListener = new CqlErrorListener(builder, visitor.isDetailedErrorsEnabled());
        cqlLexer lexer = new cqlLexer(is);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)errorListener);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        cqlParser parser = new cqlParser((TokenStream)tokens);
        parser.setBuildParseTree(true);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        cqlParser.LibraryContext tree = parser.library();
        CqlPreprocessorVisitor preprocessor = new CqlPreprocessorVisitor();
        preprocessor.setTokenStream((TokenStream)tokens);
        preprocessor.visit((ParseTree)tree);
        visitor.setTokenStream((TokenStream)tokens);
        visitor.setLibraryInfo(preprocessor.getLibraryInfo());
        this.visitResult = visitor.visit((ParseTree)tree);
        this.library = builder.getLibrary();
        this.compiledLibrary = builder.getCompiledLibrary();
        this.retrieves = visitor.getRetrieves();
        this.exceptions.addAll(builder.getExceptions());
        this.errors.addAll(builder.getErrors());
        this.warnings.addAll(builder.getWarnings());
        this.messages.addAll(builder.getMessages());
        return this.library;
    }

    private class CqlErrorListener
    extends BaseErrorListener {
        private LibraryBuilder builder;
        private boolean detailedErrors;

        public CqlErrorListener(LibraryBuilder builder, boolean detailedErrors) {
            this.builder = builder;
            this.detailedErrors = detailedErrors;
        }

        private VersionedIdentifier extractLibraryIdentifier(cqlParser parser) {
            cqlParser.LibraryDefinitionContext ldc;
            ParserRuleContext context = parser.getContext();
            while (context != null && !(context instanceof cqlParser.LibraryContext)) {
                context = context.parent;
            }
            if (context instanceof cqlParser.LibraryContext && (ldc = ((cqlParser.LibraryContext)context).libraryDefinition()) != null && ldc.qualifiedIdentifier() != null && ldc.qualifiedIdentifier().identifier() != null) {
                return new VersionedIdentifier().withId(StringEscapeUtils.unescapeCql(ldc.qualifiedIdentifier().identifier().getText()));
            }
            return null;
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            VersionedIdentifier libraryIdentifier = this.builder.getLibraryIdentifier();
            if (libraryIdentifier == null) {
                if (recognizer instanceof cqlParser) {
                    libraryIdentifier = this.extractLibraryIdentifier((cqlParser)recognizer);
                }
                if (libraryIdentifier == null) {
                    libraryIdentifier = CqlCompiler.this.sourceInfo;
                }
            }
            TrackBack trackback = new TrackBack(libraryIdentifier, line, charPositionInLine, line, charPositionInLine);
            if (this.detailedErrors) {
                this.builder.recordParsingException(new CqlSyntaxException(msg, trackback, (Throwable)e));
                this.builder.recordParsingException(new CqlCompilerException(msg, trackback, (Throwable)e));
            } else if (offendingSymbol instanceof CommonToken) {
                CommonToken token = (CommonToken)offendingSymbol;
                this.builder.recordParsingException(new CqlSyntaxException(String.format("Syntax error at %s", token.getText()), trackback, (Throwable)e));
            } else {
                this.builder.recordParsingException(new CqlSyntaxException("Syntax error", trackback, (Throwable)e));
            }
        }
    }
}

