/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.fhir.npm;

import java.util.ArrayList;
import java.util.List;
import org.cqframework.fhir.npm.NpmPackageManager;
import org.cqframework.fhir.utilities.IGContext;
import org.hl7.cql.model.NamespaceInfo;
import org.hl7.fhir.utilities.npm.NpmPackage;

public class NpmProcessor {
    private NpmPackageManager packageManager;
    private IGContext igContext;

    public NpmPackageManager getPackageManager() {
        if (this.packageManager == null) {
            throw new IllegalStateException("Package manager is not available outside of an ig context");
        }
        return this.packageManager;
    }

    public IGContext getIgContext() {
        return this.igContext;
    }

    public NpmProcessor(IGContext igContext) {
        this.igContext = igContext;
        if (igContext != null) {
            this.packageManager = new NpmPackageManager(igContext.getSourceIg());
        }
    }

    public NamespaceInfo getIgNamespace() {
        if (this.igContext != null) {
            return new NamespaceInfo(this.igContext.getPackageId(), this.igContext.getCanonicalBase());
        }
        return null;
    }

    public List<NamespaceInfo> getNamespaces() {
        ArrayList<NamespaceInfo> namespaceInfos = new ArrayList<NamespaceInfo>();
        if (this.packageManager != null) {
            List<NpmPackage> packages = this.packageManager.getNpmList();
            for (NpmPackage p : packages) {
                if (p.name() == null || p.name().isEmpty() || p.canonical() == null || p.canonical().isEmpty()) continue;
                NamespaceInfo ni = new NamespaceInfo(p.name(), p.canonical());
                namespaceInfos.add(ni);
            }
        }
        return namespaceInfos;
    }
}

