/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.model;

import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.Label;
import guru.nidi.graphviz.attribute.SimpleLabel;
import guru.nidi.graphviz.attribute.validate.AttributeValidator;
import guru.nidi.graphviz.attribute.validate.ValidatorMessage;
import guru.nidi.graphviz.model.Compass;
import guru.nidi.graphviz.model.ImmutablePortNode;
import guru.nidi.graphviz.model.Link;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.model.MutableNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;

class SerializerImpl {
    private final MutableGraph graph;
    private final StringBuilder str;
    private final AttributeValidator validator;
    private final Consumer<ValidatorMessage> messageConsumer;

    SerializerImpl(MutableGraph graph, AttributeValidator validator, Consumer<ValidatorMessage> messageConsumer) {
        this.graph = graph;
        this.validator = validator;
        this.messageConsumer = messageConsumer;
        this.str = new StringBuilder();
    }

    String serialize() {
        this.toplevelGraph(this.graph);
        return this.str.toString();
    }

    private void toplevelGraph(MutableGraph graph) {
        boolean useDir = this.hasDifferentlyDirectedSubgraphs(graph);
        this.str.append(graph.strict ? "strict " : "").append(graph.directed || useDir ? "digraph " : "graph ");
        if (!graph.name.isContentEmpty()) {
            this.str.append(graph.name.serialized()).append(' ');
        }
        this.doGraph(graph, useDir, AttributeValidator.Scope.GRAPH);
    }

    private void subGraph(MutableGraph graph, boolean useDir) {
        if (!graph.name.isContentEmpty() || graph.cluster) {
            this.str.append("subgraph ").append((graph.cluster ? Label.of("cluster_" + graph.name) : graph.name).serialized()).append(' ');
        }
        this.doGraph(graph, useDir, graph.cluster ? AttributeValidator.Scope.CLUSTER : AttributeValidator.Scope.SUB_GRAPH);
    }

    private void doGraph(MutableGraph graph, boolean useDir, AttributeValidator.Scope scope) {
        this.str.append("{\n");
        if (useDir && graph.graphAttrs.get("dir") == null) {
            this.attributes("edge", Attributes.attr("dir", graph.directed ? "forward" : "none"), AttributeValidator.Scope.EDGE, "");
        }
        this.graphAttrs(graph, scope);
        ArrayList<MutableNode> nodes = new ArrayList<MutableNode>();
        ArrayList<MutableGraph> graphs = new ArrayList<MutableGraph>();
        Collection<LinkSource> linkSources = this.linkedNodes(graph.nodes);
        linkSources.addAll(this.linkedNodes(graph.subgraphs));
        for (LinkSource linkSource : linkSources) {
            if (linkSource instanceof MutableNode) {
                MutableNode node = (MutableNode)linkSource;
                int i = this.indexOfName(nodes, node.name);
                if (i < 0) {
                    nodes.add(node);
                    continue;
                }
                nodes.set(i, node.copy().merge((MutableNode)nodes.get(i)));
                continue;
            }
            graphs.add((MutableGraph)linkSource);
        }
        this.nodes(graph, nodes);
        this.graphs(graphs, nodes, useDir);
        this.edges(nodes, useDir);
        this.edges(graphs, useDir);
        this.str.append('}');
    }

    private boolean hasDifferentlyDirectedSubgraphs(MutableGraph graph) {
        return Stream.concat(this.linkedNodes(graph.nodes).stream(), this.linkedNodes(graph.subgraphs).stream()).filter(n -> n instanceof MutableGraph).map(n -> (MutableGraph)n).anyMatch(sub -> sub.directed != graph.directed);
    }

    private void graphAttrs(MutableGraph graph, AttributeValidator.Scope scope) {
        this.attributes("graph", graph.graphAttrs, scope, "Graph attrs of '" + graph.name.toString() + "'");
        this.attributes("node", graph.nodeAttrs, AttributeValidator.Scope.NODE, "Node attrs of '" + graph.name.toString() + "'");
        this.attributes("edge", graph.linkAttrs, AttributeValidator.Scope.EDGE, "Edge attrs of '" + graph.name.toString() + "'");
    }

    private int indexOfName(List<MutableNode> nodes, Label name) {
        for (int i = 0; i < nodes.size(); ++i) {
            if (!nodes.get((int)i).name.equals(name)) continue;
            return i;
        }
        return -1;
    }

    private void attributes(String name, Attributes<?> attributed, AttributeValidator.Scope scope, String pos) {
        if (!attributed.isEmpty()) {
            this.str.append(name);
            this.attrs(attributed, scope, pos);
            this.str.append('\n');
        }
    }

    private Collection<LinkSource> linkedNodes(Collection<? extends LinkSource> nodes) {
        LinkedHashSet<LinkSource> visited = new LinkedHashSet<LinkSource>();
        for (LinkSource linkSource : nodes) {
            this.linkedNodes(linkSource, visited);
        }
        return visited;
    }

    private void linkedNodes(LinkSource linkSource, Set<LinkSource> visited) {
        if (!visited.contains(linkSource)) {
            visited.add(linkSource);
            for (Link link : linkSource.links()) {
                this.linkedNodes(link.to.asLinkSource(), visited);
            }
        }
    }

    private void nodes(MutableGraph graph, List<MutableNode> nodes) {
        for (MutableNode node : nodes) {
            if (node.attributes.isEmpty() && (!graph.nodes.contains(node) || !node.links.isEmpty() || this.isLinked(node, nodes))) continue;
            this.node(node);
            this.str.append('\n');
        }
    }

    private void node(MutableNode node) {
        this.str.append(node.name.serialized());
        this.attrs(node.attributes, AttributeValidator.Scope.NODE, "Node '" + node.name.toString() + "'");
    }

    private boolean isLinked(MutableNode node, List<MutableNode> nodes) {
        for (MutableNode m : nodes) {
            for (Link link : m.links) {
                if (!this.isNode(link.to, node)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isLinked(MutableGraph graph, List<? extends LinkSource> linkSources) {
        for (LinkSource linkSource : linkSources) {
            for (Link link : linkSource.links()) {
                if (!link.to.equals(graph)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNode(LinkTarget target, MutableNode node) {
        return target == node || target instanceof ImmutablePortNode && ((ImmutablePortNode)target).node() == node;
    }

    private void graphs(List<MutableGraph> graphs, List<MutableNode> nodes, boolean useDir) {
        for (MutableGraph graph : graphs) {
            if (!graph.links.isEmpty() || this.isLinked(graph, nodes) || this.isLinked(graph, graphs)) continue;
            this.subGraph(graph, useDir);
            this.str.append('\n');
        }
    }

    private void edges(List<? extends LinkSource> linkSources, boolean useDir) {
        for (LinkSource linkSource : linkSources) {
            for (Link link : linkSource.links()) {
                this.linkTarget(link.from, useDir);
                this.str.append(this.graph.directed || useDir ? " -> " : " -- ");
                this.linkTarget(link.to, useDir);
                this.attrs(link.attributes, AttributeValidator.Scope.EDGE, "Edge '" + link.from.name().toString() + "--" + link.to.name().toString() + "'");
                this.str.append('\n');
            }
        }
    }

    private void linkTarget(Object linkable, boolean useDir) {
        if (linkable instanceof MutableNode) {
            this.str.append(((MutableNode)linkable).name.serialized());
        } else if (linkable instanceof ImmutablePortNode) {
            this.port((ImmutablePortNode)linkable);
        } else if (linkable instanceof MutableGraph) {
            this.subGraph((MutableGraph)linkable, useDir);
        } else {
            throw new IllegalStateException("unexpected link target " + linkable);
        }
    }

    private void port(ImmutablePortNode portNode) {
        Compass compass;
        this.str.append(portNode.name().serialized());
        String record = portNode.port().record();
        if (record != null) {
            this.str.append(':').append(SimpleLabel.of(record).serialized());
        }
        if ((compass = portNode.port().compass()) != null) {
            this.str.append(':').append(compass.value);
        }
    }

    private void attrs(Attributes<?> attrs, AttributeValidator.Scope scope, String pos) {
        if (!attrs.isEmpty()) {
            this.str.append(" [");
            boolean first = true;
            for (Map.Entry<String, Object> attr : attrs) {
                if (attr.getValue() == null) continue;
                if (first) {
                    first = false;
                } else {
                    this.str.append(',');
                }
                this.attr(attr.getKey(), attr.getValue(), scope, pos);
            }
            this.str.append(']');
        }
    }

    private void attr(String key, Object value, AttributeValidator.Scope scope, String pos) {
        this.str.append(SimpleLabel.of(key).serialized()).append('=').append(SimpleLabel.of(value).serialized());
        this.validate(key, value, scope, pos);
    }

    private void validate(String key, Object value, AttributeValidator.Scope scope, String pos) {
        this.validator.validate(key, value, scope).forEach(msg -> this.messageConsumer.accept(msg.at(pos)));
    }
}

