/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Set;

class FontMeasurer {
    private static final FontRenderContext FONT_RENDER_CONTEXT = new BufferedImage(1, 1, 5).createGraphics().getFontRenderContext();
    private static final double COURIER_WIDTH = 0.5999;
    private static final Font COURIER = new Font("Courier", 0, 10);
    private static final double COURIER_SPACE_WIDTH = FontMeasurer.charWidth(COURIER, ' ');
    private static final double COURIER_BORDER_WIDTH = FontMeasurer.borderWidth(COURIER);
    private static final double[] COURIER_WIDTHS = FontMeasurer.courierWidths();
    private final Set<String> fonts = new HashSet<String>();

    FontMeasurer() {
    }

    private static double[] courierWidths() {
        double[] w = new double[256];
        for (int i = 32; i < 256; ++i) {
            w[i] = FontMeasurer.charWidth(COURIER, (char)i);
        }
        return w;
    }

    private static double charWidth(Font font, char c) {
        return font.createGlyphVector(FONT_RENDER_CONTEXT, new char[]{'8', c, '8'}).getVisualBounds().getWidth();
    }

    private static double borderWidth(Font font) {
        return font.createGlyphVector(FONT_RENDER_CONTEXT, new char[]{'8', '8'}).getVisualBounds().getWidth();
    }

    double[] measureFont(String name) {
        if (this.fonts.contains(name)) {
            return new double[0];
        }
        this.fonts.add(name);
        Font font = new Font(name, 0, 10);
        double spaceWidth = FontMeasurer.charWidth(font, ' ');
        double borderWidth = FontMeasurer.borderWidth(font);
        double[] w = new double[256];
        for (int i = 0; i < 256; ++i) {
            w[i] = 0.5999 * (i <= 32 ? (spaceWidth - borderWidth) / (COURIER_SPACE_WIDTH - COURIER_BORDER_WIDTH) : (FontMeasurer.charWidth(font, (char)i) - borderWidth) / (COURIER_WIDTHS[i] - COURIER_BORDER_WIDTH));
        }
        return w;
    }
}

