/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.attribute.validate;

import guru.nidi.graphviz.attribute.validate.Datatype;
import guru.nidi.graphviz.attribute.validate.Datatypes;
import guru.nidi.graphviz.attribute.validate.ValidatorMessage;

class ColorListDatatype
extends Datatype {
    ColorListDatatype() {
        super("list of colors");
    }

    @Override
    ValidatorMessage validate(Object value) {
        String[] colors = value.toString().split(":");
        double[] sum = new double[]{0.0};
        for (String color : colors) {
            int pos = color.indexOf(59);
            ValidatorMessage colorMsg = Datatypes.COLOR.validate(pos < 0 ? color : color.substring(0, pos));
            if (colorMsg != null) {
                return colorMsg;
            }
            String factorMsg = this.checkFactor(pos, color, sum);
            if (factorMsg == null) continue;
            return new ValidatorMessage(ValidatorMessage.Severity.ERROR, "'" + value + "': " + factorMsg);
        }
        if (sum[0] > 1.0) {
            return new ValidatorMessage(ValidatorMessage.Severity.ERROR, "'" + value + "': The sum of the factors is greater than 1.");
        }
        return null;
    }

    private String checkFactor(int pos, String color, double[] sum) {
        if (pos >= 0) {
            if (pos == color.length() - 1) {
                return "missing color factor after ';'.";
            }
            String factor = color.substring(pos + 1);
            Double factorValue = ColorListDatatype.doubleValue(factor);
            if (factorValue == null) {
                return factor + " is not a valid number.";
            }
            if (factorValue < 0.0 || factorValue > 1.0) {
                return factor + " is not between 0 and 1.";
            }
            sum[0] = sum[0] + factorValue;
        }
        return null;
    }
}

