/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.attribute.validate;

import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.For;
import guru.nidi.graphviz.attribute.validate.AttributeConfig;
import guru.nidi.graphviz.attribute.validate.AttributeConfigs;
import guru.nidi.graphviz.attribute.validate.Datatype;
import guru.nidi.graphviz.attribute.validate.ValidatorEngine;
import guru.nidi.graphviz.attribute.validate.ValidatorFormat;
import guru.nidi.graphviz.attribute.validate.ValidatorMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AttributeValidator {
    private static final Logger LOG = LoggerFactory.getLogger(AttributeValidator.class);
    private final ValidatorEngine engine;
    private final ValidatorFormat format;

    public AttributeValidator() {
        this(ValidatorEngine.UNKNOWN_ENGINE, ValidatorFormat.UNKNOWN_FORMAT);
    }

    private AttributeValidator(ValidatorEngine engine, ValidatorFormat format) {
        this.engine = engine;
        this.format = format;
    }

    public AttributeValidator forEngine(ValidatorEngine engine) {
        return new AttributeValidator(engine, this.format);
    }

    public AttributeValidator forFormat(ValidatorFormat format) {
        return new AttributeValidator(this.engine, format);
    }

    public List<ValidatorMessage> validate(Attributes<? extends For> attrs, Scope scope) {
        return StreamSupport.stream(attrs.spliterator(), false).flatMap(entry -> this.validate((String)entry.getKey(), entry.getValue(), scope).stream()).collect(Collectors.toList());
    }

    public List<ValidatorMessage> validate(String key, Object value, Scope scope) {
        List<AttributeConfig> configs = AttributeConfigs.get(key);
        if (configs == null) {
            return Collections.singletonList(new ValidatorMessage(ValidatorMessage.Severity.ERROR, key, "Attribute is unknown."));
        }
        List<AttributeConfig> engineConfigs = this.findConfigsForEngine(configs);
        if (engineConfigs.isEmpty()) {
            return Collections.singletonList(new ValidatorMessage(ValidatorMessage.Severity.ERROR, key, "Attribute is not allowed for engine '" + (Object)((Object)this.engine) + "'."));
        }
        List<AttributeConfig> formatConfigs = this.findConfigsForFormat(configs);
        if (formatConfigs.isEmpty()) {
            return Collections.singletonList(new ValidatorMessage(ValidatorMessage.Severity.ERROR, key, "Attribute is not allowed for format '" + (Object)((Object)this.format) + "'."));
        }
        List<AttributeConfig> matchConfigs = AttributeValidator.intersect(engineConfigs, formatConfigs);
        if (matchConfigs.isEmpty()) {
            return Collections.singletonList(new ValidatorMessage(ValidatorMessage.Severity.ERROR, key, "Attribute is not allowed for engine '" + (Object)((Object)this.engine) + "' and format '" + (Object)((Object)this.format) + "'."));
        }
        if (matchConfigs.size() > 1) {
            matchConfigs = matchConfigs.stream().filter(c -> c.scopes.contains((Object)scope)).collect(Collectors.toList());
        }
        if (matchConfigs.isEmpty()) {
            return Collections.singletonList(new ValidatorMessage(ValidatorMessage.Severity.ERROR, key, "Attribute is not allowed for " + (Object)((Object)scope) + "s."));
        }
        if (matchConfigs.size() > 1) {
            LOG.warn("Found multiple attribute configurations for " + (Object)((Object)this.engine) + ", " + (Object)((Object)this.format) + " and " + (Object)((Object)scope) + ". This should not happen.");
        }
        ArrayList<ValidatorMessage> messages = new ArrayList<ValidatorMessage>();
        this.validateScope(messages, key, matchConfigs.get(0), scope);
        this.validateValue(messages, key, matchConfigs.get(0), value);
        this.validateType(messages, key, matchConfigs.get(0), value);
        return messages;
    }

    private static <T> List<T> intersect(List<T> as, List<T> bs) {
        return as.stream().filter(bs::contains).collect(Collectors.toList());
    }

    private List<AttributeConfig> findConfigsForEngine(List<AttributeConfig> configs) {
        return configs.stream().filter(c -> {
            if (this.engine == ValidatorEngine.UNKNOWN_ENGINE || c.engines.isEmpty()) {
                return true;
            }
            if (c.engines.contains((Object)ValidatorEngine.NOT_DOT) && this.engine == ValidatorEngine.DOT) {
                return false;
            }
            return c.engines.contains((Object)this.engine);
        }).collect(Collectors.toList());
    }

    private List<AttributeConfig> findConfigsForFormat(List<AttributeConfig> configs) {
        return configs.stream().filter(c -> {
            if (this.format == ValidatorFormat.OTHER && !c.formats.isEmpty()) {
                return false;
            }
            if (this.format == ValidatorFormat.UNKNOWN_FORMAT || c.formats.isEmpty()) {
                return true;
            }
            return c.formats.contains((Object)this.format);
        }).collect(Collectors.toList());
    }

    private void validateScope(List<ValidatorMessage> messages, String key, AttributeConfig config, Scope scope) {
        if (!config.scopes.contains((Object)scope)) {
            messages.add(new ValidatorMessage(ValidatorMessage.Severity.ERROR, key, "Attribute is not allowed for " + (Object)((Object)scope) + "s."));
        }
    }

    private void validateValue(List<ValidatorMessage> messages, String key, AttributeConfig config, Object value) {
        if (config.defVal != null && this.isValueEquals(config.defVal, value)) {
            messages.add(new ValidatorMessage(ValidatorMessage.Severity.INFO, key, "Attribute is set to its default value '" + config.defVal + "'."));
        }
        Double val = Datatype.tryParseDouble(value.toString());
        if (config.min != null && val != null && val < config.min) {
            messages.add(new ValidatorMessage(ValidatorMessage.Severity.WARN, key, "Attribute has a minimum of '" + config.min + "' but is set to '" + value + "'."));
        }
        if (config.max != null && val != null && val > config.max) {
            messages.add(new ValidatorMessage(ValidatorMessage.Severity.WARN, key, "Attribute has a maximum of '" + config.max + "' but is set to '" + value + "'."));
        }
    }

    private void validateType(List<ValidatorMessage> messages, String key, AttributeConfig config, Object value) {
        List typeMessages = config.types.stream().map(t -> t.validate(value)).collect(Collectors.toList());
        if (typeMessages.size() == 1) {
            if (typeMessages.get(0) != null) {
                messages.add(((ValidatorMessage)typeMessages.get(0)).atAttribute(key));
            }
        } else if (typeMessages.stream().noneMatch(Objects::isNull)) {
            ArrayList<String> lines = new ArrayList<String>();
            for (int i = 0; i < config.types.size(); ++i) {
                lines.add("As " + config.types.get((int)i).name + ": " + ((ValidatorMessage)typeMessages.get((int)i)).message);
            }
            messages.add(new ValidatorMessage(ValidatorMessage.Severity.ERROR, key, "'" + value + "' is not valid for any of the possible types:\n" + String.join((CharSequence)"\n", lines)));
        }
    }

    private boolean isValueEquals(Object config, Object value) {
        if (config instanceof Double) {
            Double val = Datatype.doubleValue(value);
            return val != null && Math.abs((Double)config - val) < 1.0E-4;
        }
        if (config instanceof Integer) {
            Integer val = Datatype.intValue(value);
            return val != null && val.equals(config);
        }
        if (config instanceof Boolean) {
            Boolean val = Datatype.boolValue(value);
            return val != null && val.equals(config);
        }
        return config.toString().equals(value.toString());
    }

    public static enum Scope {
        GRAPH,
        SUB_GRAPH,
        CLUSTER,
        NODE,
        EDGE;


        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH).replace("_", "");
        }
    }
}

