/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.attribute;

import java.util.Objects;

public class SimpleLabel {
    final String value;
    final boolean html;

    SimpleLabel(String value, boolean html) {
        this.value = value;
        this.html = html;
    }

    public static SimpleLabel of(String value) {
        return new SimpleLabel(value, false);
    }

    public static SimpleLabel of(Object value) {
        return value instanceof SimpleLabel ? (SimpleLabel)value : SimpleLabel.of(value.toString());
    }

    public String serialized() {
        return this.html ? "<" + this.value + ">" : this.quoted();
    }

    private String quoted() {
        int endSlashes;
        for (endSlashes = 0; endSlashes < this.value.length() && this.value.charAt(this.value.length() - 1 - endSlashes) == '\\'; ++endSlashes) {
        }
        String end = endSlashes % 2 == 1 ? "\\" : "";
        return "\"" + this.value.replace("\"", "\\\"").replace("\n", "\\n") + end + "\"";
    }

    public String value() {
        return this.value;
    }

    public boolean contentEquals(String s) {
        return this.value.equals(s);
    }

    public boolean isContentEmpty() {
        return this.value.isEmpty();
    }

    public boolean isHtml() {
        return this.html;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleLabel that = (SimpleLabel)o;
        return this.html == that.html && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.html);
    }

    public String toString() {
        return this.value;
    }
}

