/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.web.servlet.view.xdocreport;

import fr.opensagres.web.servlet.view.xdocreport.IXDocReportConfiguration;
import fr.opensagres.xdocreport.converter.IConverter;
import fr.opensagres.xdocreport.converter.MimeMapping;
import fr.opensagres.xdocreport.converter.Options;
import fr.opensagres.xdocreport.converter.XDocConverterException;
import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.core.utils.HttpHeaderUtils;
import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.document.IXDocReport;
import fr.opensagres.xdocreport.document.dump.DumperOptions;
import fr.opensagres.xdocreport.document.dump.IDumper;
import fr.opensagres.xdocreport.document.registry.XDocReportRegistry;
import fr.opensagres.xdocreport.template.IContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.ApplicationContextException;
import org.springframework.core.io.Resource;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class XDocReportView
extends AbstractUrlBasedView {
    private boolean loadOnInit = true;
    private String reportId;
    private String templateEngineId;
    private boolean cacheReport = true;
    private String convertTo;
    private String convertVia;
    private boolean generateContentDisposition = true;
    private IXDocReportConfiguration configuration;

    public void setLoadOnInit(boolean loadOnInit) {
        this.loadOnInit = loadOnInit;
    }

    public boolean isLoadOnInit() {
        return this.loadOnInit;
    }

    public void setReportId(String reportId) {
        this.reportId = reportId;
    }

    public String getReportId() {
        if (this.reportId != null) {
            return this.reportId;
        }
        return this.getBeanName();
    }

    public void setTemplateEngineId(String templateEngineId) {
        this.templateEngineId = templateEngineId;
    }

    protected String getTemplateEngineId() {
        return this.templateEngineId;
    }

    public void setCacheReport(boolean cacheReport) {
        this.cacheReport = cacheReport;
    }

    public boolean isCacheReport() {
        return this.cacheReport;
    }

    public void setConvertTo(String convertTo) {
        this.convertTo = convertTo;
    }

    public String getConvertTo() {
        return this.convertTo;
    }

    public void setConvertVia(String convertVia) {
        this.convertVia = convertVia;
    }

    public String getConvertVia() {
        return this.convertVia;
    }

    public void setGenerateContentDisposition(boolean generateContentDisposition) {
        this.generateContentDisposition = generateContentDisposition;
    }

    public boolean isGenerateContentDisposition() {
        return this.generateContentDisposition;
    }

    public void setConfiguration(IXDocReportConfiguration configuration) {
        this.configuration = configuration;
    }

    public IXDocReportConfiguration getConfiguration() {
        return this.configuration;
    }

    protected final void initApplicationContext() throws ApplicationContextException {
        if (this.isLoadOnInit()) {
            this.getReport();
        }
        this.onInit();
    }

    protected void onInit() {
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.getTemplateEngineId() == null) {
            throw new IllegalArgumentException("Property 'templateEngineId' is required");
        }
    }

    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IXDocReport report = this.getReport();
        if (report == null) {
            throw new IllegalStateException("No main report defined for 'renderMergedOutputModel' - specify a 'url' on this view or override 'getReport()'");
        }
        IContext context = this.createContext(report, model);
        Options options = this.getOptionsConverter(model);
        DumperOptions dumperOptions = this.getOptionsDumper(model);
        if (options == null) {
            this.doProcessReport(report, context, dumperOptions, request, response);
        } else {
            this.doProcessReportWithConverter(report, context, options, dumperOptions, request, response);
        }
    }

    protected IContext createContext(IXDocReport report, Map<String, Object> model) throws XDocReportException {
        return report.createContext(model);
    }

    protected Options getOptionsConverter(Map<String, Object> model) {
        String to = this.getConvertTo();
        if (to != null) {
            String via = this.getConvertVia();
            Options options = Options.getTo((String)to);
            if (via != null) {
                options.via(via);
            }
            return options;
        }
        return (Options)CollectionUtils.findValueOfType(model.values(), Options.class);
    }

    protected DumperOptions getOptionsDumper(Map<String, Object> model) {
        return (DumperOptions)CollectionUtils.findValueOfType(model.values(), DumperOptions.class);
    }

    public IXDocReport getReport() throws ApplicationContextException {
        IXDocReport report;
        XDocReportRegistry registry = this.getRegistry();
        String reportId = this.getReportId();
        if (StringUtils.isNotEmpty((String)reportId) && (report = registry.getReport(reportId)) != null) {
            return report;
        }
        return this.loadReport(reportId, registry);
    }

    protected IXDocReport loadReport(String reportId, XDocReportRegistry registry) {
        String url = this.getUrl();
        if (url == null) {
            return null;
        }
        Resource resource = this.getApplicationContext().getResource(url);
        try {
            InputStream is = resource.getInputStream();
            String templateEngineId = this.getTemplateEngineId();
            IXDocReport report = registry.loadReport(is, reportId, templateEngineId, this.isCacheReport());
            this.reportId = report.getId();
            IXDocReportConfiguration configuration = this.getConfiguration();
            if (configuration != null) {
                configuration.configure(report);
            }
            return report;
        }
        catch (Exception ex) {
            throw new ApplicationContextException("Could not load XDocReport report from " + resource, (Throwable)ex);
        }
    }

    protected XDocReportRegistry getRegistry() {
        return XDocReportRegistry.getRegistry();
    }

    private void doProcessReport(IXDocReport report, IContext context, DumperOptions dumperOptions, HttpServletRequest request, HttpServletResponse response) throws XDocReportException, IOException {
        if (dumperOptions != null) {
            IDumper dumper = report.getDumper(dumperOptions);
            this.prepareHTTPResponse(report.getId(), dumper.getMimeMapping(), request, response);
            report.dump(context, dumperOptions, (OutputStream)response.getOutputStream());
        } else {
            this.prepareHTTPResponse(report.getId(), report.getMimeMapping(), request, response);
            report.process(context, (OutputStream)response.getOutputStream());
        }
    }

    protected void doProcessReportWithConverter(IXDocReport report, IContext context, Options options, DumperOptions dumperOptions, HttpServletRequest request, HttpServletResponse response) throws XDocReportException, IOException, XDocConverterException {
        if (dumperOptions != null) {
            IDumper dumper = report.getDumper(dumperOptions);
            this.prepareHTTPResponse(report.getId(), dumper.getMimeMapping(), request, response);
            report.dump(context, dumperOptions, (OutputStream)response.getOutputStream());
        } else {
            IConverter converter = report.getConverter(options);
            this.prepareHTTPResponse(report.getId(), converter.getMimeMapping(), request, response);
            report.convert(context, options, (OutputStream)response.getOutputStream());
        }
    }

    protected void prepareHTTPResponse(String reportId, MimeMapping mimeMapping, HttpServletRequest request, HttpServletResponse response) {
        String contentDisposition;
        if (mimeMapping != null) {
            response.setContentType(mimeMapping.getMimeType());
        }
        if (this.isGenerateContentDisposition() && StringUtils.isNotEmpty((String)(contentDisposition = this.getContentDisposition(reportId, mimeMapping, request)))) {
            response.setHeader("Content-Disposition", contentDisposition.toString());
        }
        if (this.isDisableHTTPResponCache()) {
            this.disableHTTPResponCache(response);
        }
    }

    protected boolean isDisableHTTPResponCache() {
        return true;
    }

    protected String getContentDisposition(String reportId, MimeMapping mimeMapping, HttpServletRequest request) {
        if (mimeMapping != null) {
            String fileName = mimeMapping.formatFileName(reportId);
            return this.getContentDisposition(fileName);
        }
        return null;
    }

    protected String getContentDisposition(String fileName) {
        return HttpHeaderUtils.getAttachmentFileName((String)fileName);
    }

    protected void disableHTTPResponCache(HttpServletResponse response) {
        response.setHeader("Expires", "Sat, 6 May 1995 12:00:00 GMT");
        response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        response.setHeader("Pragma", "no-cache");
    }
}

