/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.signature.SignatureRequirementsChecker;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.XAdESTimestampParameters;
import eu.europa.esig.dss.xades.signature.XAdESLevelC;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class XAdESLevelX
extends XAdESLevelC {
    public XAdESLevelX(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    @Override
    protected void extendSignatures(List<AdvancedSignature> signatures) {
        super.extendSignatures(signatures);
        List<AdvancedSignature> signaturesToExtend = this.getExtendToXLevelSignatures(signatures);
        if (Utils.isCollectionEmpty(signaturesToExtend)) {
            return;
        }
        SignatureRequirementsChecker signatureRequirementsChecker = this.getSignatureRequirementsChecker();
        if (SignatureLevel.XAdES_X.equals((Object)this.params.getSignatureLevel())) {
            signatureRequirementsChecker.assertExtendToXLevelPossible(signaturesToExtend);
        }
        signatureRequirementsChecker.assertSignaturesValid(signaturesToExtend);
        for (AdvancedSignature signature : signaturesToExtend) {
            this.initializeSignatureBuilder((XAdESSignature)signature);
            if (!this.xLevelExtensionRequired(signature)) continue;
            Element levelCUnsignedProperties = (Element)this.unsignedSignaturePropertiesDom.cloneNode(true);
            XAdESTimestampParameters signatureTimestampParameters = this.params.getSignatureTimestampParameters();
            DigestAlgorithm digestAlgorithm = signatureTimestampParameters.getDigestAlgorithm();
            String canonicalizationMethod = signatureTimestampParameters.getCanonicalizationMethod();
            DSSMessageDigest messageDigest = this.xadesSignature.getTimestampSource().getTimestampX1MessageDigest(digestAlgorithm, canonicalizationMethod, this.params.isEn319132());
            this.createXAdESTimeStampType(TimestampType.VALIDATION_DATA_TIMESTAMP, canonicalizationMethod, messageDigest);
            this.unsignedSignaturePropertiesDom = this.indentIfPrettyPrint(this.unsignedSignaturePropertiesDom, levelCUnsignedProperties);
        }
    }

    private List<AdvancedSignature> getExtendToXLevelSignatures(List<AdvancedSignature> signatures) {
        ArrayList<AdvancedSignature> signaturesToExtend = new ArrayList<AdvancedSignature>();
        for (AdvancedSignature signature : signatures) {
            if (!this.xLevelExtensionRequired(signature)) continue;
            signaturesToExtend.add(signature);
        }
        return signaturesToExtend;
    }

    private boolean xLevelExtensionRequired(AdvancedSignature signature) {
        return SignatureLevel.XAdES_X.equals((Object)this.params.getSignatureLevel()) || !signature.hasXProfile();
    }
}

