/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.model.SerializableCounterSignatureParameters;
import eu.europa.esig.dss.model.identifier.TokenIdentifier;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import java.util.Date;
import java.util.Objects;

public class XAdESCounterSignatureParameters
extends XAdESSignatureParameters
implements SerializableCounterSignatureParameters {
    private static final long serialVersionUID = -1443369404631708953L;
    private String signatureIdToCounterSign;
    private String counterSignatureCanonicalizationMethod = "http://www.w3.org/2001/10/xml-exc-c14n#";

    public String getSignatureIdToCounterSign() {
        return this.signatureIdToCounterSign;
    }

    public void setSignatureIdToCounterSign(String signatureId) {
        this.signatureIdToCounterSign = signatureId;
    }

    public String getCounterSignatureCanonicalizationMethod() {
        return this.counterSignatureCanonicalizationMethod;
    }

    public void setCounterSignatureCanonicalizationMethod(String counterSignatureCanonicalizationMethod) {
        this.counterSignatureCanonicalizationMethod = counterSignatureCanonicalizationMethod;
    }

    public String getDeterministicId() {
        String deterministicId = this.getContext().getDeterministicId();
        if (deterministicId == null) {
            TokenIdentifier identifier = this.getSigningCertificate() == null ? null : this.getSigningCertificate().getDSSId();
            deterministicId = DSSUtils.getCounterSignatureDeterministicId((Date)this.bLevel().getSigningDate(), (TokenIdentifier)identifier, (String)this.signatureIdToCounterSign);
            this.getContext().setDeterministicId(deterministicId);
        }
        return deterministicId;
    }

    @Override
    public String toString() {
        return "XAdESCounterSignatureParameters [signatureIdToCounterSign='" + this.signatureIdToCounterSign + '\'' + ", counterSignatureCanonicalizationMethod='" + this.counterSignatureCanonicalizationMethod + '\'' + "] " + super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        XAdESCounterSignatureParameters that = (XAdESCounterSignatureParameters)((Object)o);
        return Objects.equals(this.signatureIdToCounterSign, that.signatureIdToCounterSign) && Objects.equals(this.counterSignatureCanonicalizationMethod, that.counterSignatureCanonicalizationMethod);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.signatureIdToCounterSign);
        result = 31 * result + Objects.hashCode(this.counterSignatureCanonicalizationMethod);
        return result;
    }
}

