/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token.predicate;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.predicate.DSSKeyEntryPredicate;
import java.util.Date;
import java.util.Objects;

public class ValidAtTimeKeyEntryPredicate
implements DSSKeyEntryPredicate {
    private final Date validationTime;

    public ValidAtTimeKeyEntryPredicate() {
        this(new Date());
    }

    public ValidAtTimeKeyEntryPredicate(Date validationTime) {
        Objects.requireNonNull(validationTime, "Validation time cannot be null!");
        this.validationTime = validationTime;
    }

    @Override
    public boolean test(DSSPrivateKeyEntry dssPrivateKeyEntry) {
        CertificateToken certificate = dssPrivateKeyEntry.getCertificate();
        if (certificate != null) {
            return this.validationTime.compareTo(certificate.getNotBefore()) >= 0 && this.validationTime.compareTo(certificate.getNotAfter()) <= 0;
        }
        return false;
    }
}

