/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token.predicate;

import eu.europa.esig.dss.enumerations.KeyUsageBit;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.predicate.DSSKeyEntryPredicate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class KeyUsageKeyEntryPredicate
implements DSSKeyEntryPredicate {
    private final Collection<KeyUsageBit> keyUsages;

    public KeyUsageKeyEntryPredicate(KeyUsageBit ... keyUsages) {
        Objects.requireNonNull(keyUsages, "KeyUsage cannot be null!");
        this.keyUsages = Arrays.asList(keyUsages);
    }

    @Override
    public boolean test(DSSPrivateKeyEntry dssPrivateKeyEntry) {
        List keyUsageBits;
        CertificateToken certificate = dssPrivateKeyEntry.getCertificate();
        if (certificate != null && (keyUsageBits = certificate.getKeyUsageBits()) != null && !keyUsageBits.isEmpty()) {
            for (KeyUsageBit keyUsageBit : keyUsageBits) {
                if (!this.keyUsages.contains(keyUsageBit)) continue;
                return true;
            }
        }
        return false;
    }
}

