/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token.predicate;

import eu.europa.esig.dss.enumerations.ExtendedKeyUsage;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.predicate.DSSKeyEntryPredicate;
import java.security.cert.CertificateParsingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ExtendedKeyUsageKeyEntryPredicate
implements DSSKeyEntryPredicate {
    private final Collection<String> extendedKeyUsageOIDs;

    public ExtendedKeyUsageKeyEntryPredicate(ExtendedKeyUsage ... extendedKeyUsages) {
        Objects.requireNonNull(extendedKeyUsages, "ExtendedKeyUsage cannot be null!");
        this.extendedKeyUsageOIDs = Arrays.stream(extendedKeyUsages).filter(Objects::nonNull).map(ExtendedKeyUsage::getOid).collect(Collectors.toSet());
    }

    public ExtendedKeyUsageKeyEntryPredicate(String ... extendedKeyUsageOIDs) {
        Objects.requireNonNull(extendedKeyUsageOIDs, "ExtendedKeyUsage OIDs cannot be null!");
        this.extendedKeyUsageOIDs = Arrays.asList(extendedKeyUsageOIDs);
    }

    @Override
    public boolean test(DSSPrivateKeyEntry dssPrivateKeyEntry) {
        List<String> extendedKeyUsages;
        CertificateToken certificate = dssPrivateKeyEntry.getCertificate();
        if (certificate != null && (extendedKeyUsages = this.getExtendedKeyUsages(certificate)) != null && !extendedKeyUsages.isEmpty()) {
            for (String extendedKeyUsage : extendedKeyUsages) {
                if (!this.extendedKeyUsageOIDs.contains(extendedKeyUsage)) continue;
                return true;
            }
        }
        return false;
    }

    private List<String> getExtendedKeyUsages(CertificateToken certificateToken) {
        try {
            return certificateToken.getCertificate().getExtendedKeyUsage();
        }
        catch (CertificateParsingException e) {
            throw new DSSException(String.format("Unable to extract ExtendedKeyUsage from a certificate token. Reason : %s", e.getMessage()), (Throwable)e);
        }
    }
}

