/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.tsp;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.TimestampBinary;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampResponseGenerator;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.TimeStampTokenGenerator;
import org.bouncycastle.util.Store;

public class KeyEntityTSPSource
implements TSPSource {
    private static final long serialVersionUID = -5082887845359355029L;
    private PrivateKey privateKey;
    private X509Certificate certificate;
    private List<X509Certificate> certificateChain;
    private final SecureRandom secureRandom = new SecureRandom();
    private Collection<DigestAlgorithm> acceptedDigestAlgorithms = Arrays.asList(DigestAlgorithm.SHA224, DigestAlgorithm.SHA256, DigestAlgorithm.SHA384, DigestAlgorithm.SHA512);
    private String tsaPolicy;
    protected Date productionTime;
    private DigestAlgorithm digestAlgorithm = DigestAlgorithm.SHA512;
    private EncryptionAlgorithm encryptionAlgorithm;

    protected KeyEntityTSPSource() {
    }

    public KeyEntityTSPSource(byte[] ksContent, String ksType, char[] ksPassword, String alias, char[] keyEntryPassword) {
        this(KeyEntityTSPSource.loadKeyStore(new ByteArrayInputStream(ksContent), ksType, ksPassword), alias, keyEntryPassword);
    }

    public KeyEntityTSPSource(String ksPath, String ksType, char[] ksPassword, String alias, char[] keyEntryPassword) throws IOException {
        this(new File(ksPath), ksType, ksPassword, alias, keyEntryPassword);
    }

    public KeyEntityTSPSource(File ksFile, String ksType, char[] ksPassword, String alias, char[] keyEntryPassword) throws IOException {
        this(Files.newInputStream(ksFile.toPath(), new OpenOption[0]), ksType, ksPassword, alias, keyEntryPassword);
    }

    public KeyEntityTSPSource(InputStream ksIs, String ksType, char[] ksPassword, String alias, char[] keyEntryPassword) {
        this(KeyEntityTSPSource.loadKeyStore(ksIs, ksType, ksPassword), alias, keyEntryPassword);
    }

    private static KeyStore loadKeyStore(InputStream keyStoreIs, String ksType, char[] keyStorePassword) {
        KeyStore keyStore;
        block8: {
            InputStream is = keyStoreIs;
            try {
                KeyStore keyStore2 = KeyStore.getInstance(ksType);
                keyStore2.load(is, keyStorePassword);
                keyStore = keyStore2;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new DSSException("Unable to instantiate KeyStore", (Throwable)e);
                }
            }
            is.close();
        }
        return keyStore;
    }

    public KeyEntityTSPSource(KeyStore keyStore, String alias, char[] keyEntryPassword) {
        Objects.requireNonNull(keyStore, "KeyStore is not defined!");
        Objects.requireNonNull(alias, "Alias is not defined!");
        Objects.requireNonNull(keyEntryPassword, "KeyEntry Password is not defined!");
        KeyStore.PrivateKeyEntry privateKeyEntry = KeyEntityTSPSource.getPrivateKeyEntry(keyStore, alias, keyEntryPassword);
        this.privateKey = privateKeyEntry.getPrivateKey();
        this.certificate = (X509Certificate)privateKeyEntry.getCertificate();
        this.certificateChain = Arrays.stream(privateKeyEntry.getCertificateChain()).map(c -> (X509Certificate)c).collect(Collectors.toList());
    }

    private static KeyStore.PrivateKeyEntry getPrivateKeyEntry(KeyStore keyStore, String alias, char[] keyEntryPassword) {
        try {
            if (!keyStore.isKeyEntry(alias)) {
                throw new IllegalArgumentException(String.format("No related/supported key entry found for alias '%s'!", alias));
            }
            if (!keyStore.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) {
                throw new IllegalArgumentException(String.format("No key entry found for alias '%s' is not instance of a PrivateKeyEntry!", alias));
            }
            return (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, new KeyStore.PasswordProtection(keyEntryPassword));
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException e) {
            throw new DSSException(String.format("Unable to recover the key entry with alias '%s'. Reason : %s", alias, e.getMessage()), (Throwable)e);
        }
    }

    public KeyEntityTSPSource(PrivateKey privateKey, CertificateToken certificateToken, List<CertificateToken> certificateChain) {
        this(privateKey, certificateToken.getCertificate(), certificateChain.stream().map(CertificateToken::getCertificate).collect(Collectors.toList()));
    }

    public KeyEntityTSPSource(PrivateKey privateKey, X509Certificate certificate, List<X509Certificate> certificateChain) {
        Objects.requireNonNull(privateKey, "PrivateKey is not defined!");
        Objects.requireNonNull(certificate, "Certificate is not defined!");
        Objects.requireNonNull(certificateChain, "Certificate chain is not defined!");
        this.privateKey = privateKey;
        this.certificate = certificate;
        this.certificateChain = certificateChain;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public void setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
    }

    public void setCertificateChain(List<X509Certificate> certificateChain) {
        this.certificateChain = certificateChain;
    }

    public void setTsaPolicy(String tsaPolicy) {
        this.tsaPolicy = tsaPolicy;
    }

    public void setAcceptedDigestAlgorithms(Collection<DigestAlgorithm> digestAlgorithms) {
        this.acceptedDigestAlgorithms = digestAlgorithms;
    }

    protected Date getProductionTime() {
        if (this.productionTime == null) {
            return new Date();
        }
        return this.productionTime;
    }

    public void setProductionTime(Date productionTime) {
        this.productionTime = productionTime;
    }

    public void setDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    public void setEncryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    @Override
    public TimestampBinary getTimeStampResponse(DigestAlgorithm digestAlgorithm, byte[] digest) {
        Objects.requireNonNull(this.privateKey, "PrivateKey is not defined! Use #setPrivateKey method.");
        Objects.requireNonNull(this.certificate, "Certificate is not defined! Use #setCertificate method.");
        Objects.requireNonNull(this.certificateChain, "Certificate chain is not defined! Use #setCertificateChain method.");
        Objects.requireNonNull(digestAlgorithm, "DigestAlgorithm is not defined!");
        Objects.requireNonNull(digest, "digest is not defined!");
        Objects.requireNonNull(this.tsaPolicy, "TSAPolicy OID is not defined! Use #setTsaPolicy method.");
        if (!this.acceptedDigestAlgorithms.contains(digestAlgorithm)) {
            throw new DSSException(String.format("DigestAlgorithm '%s' is not supported by the KeyEntityTSPSource implementation!", digestAlgorithm));
        }
        try {
            TimeStampRequest request = this.createRequest(digestAlgorithm, digest);
            TimeStampResponse response = this.generateResponse(request, digestAlgorithm);
            return this.getTimestampBinary(response);
        }
        catch (IOException | TSPException e) {
            throw new DSSException(String.format("Unable to generate a timestamp. Reason : %s", e.getMessage()), e);
        }
    }

    protected TimeStampRequest createRequest(DigestAlgorithm digestAlgorithm, byte[] digest) {
        TimeStampRequestGenerator requestGenerator = new TimeStampRequestGenerator();
        requestGenerator.setCertReq(true);
        return requestGenerator.generate(this.getASN1ObjectIdentifier(digestAlgorithm), digest);
    }

    private Set<ASN1ObjectIdentifier> getAcceptedDigestAlgorithmIdentifiers() {
        HashSet<ASN1ObjectIdentifier> result = new HashSet<ASN1ObjectIdentifier>();
        for (DigestAlgorithm acceptedDigestAlgorithm : this.acceptedDigestAlgorithms) {
            result.add(this.getASN1ObjectIdentifier(acceptedDigestAlgorithm));
        }
        return result;
    }

    private ASN1ObjectIdentifier getASN1ObjectIdentifier(DigestAlgorithm digestAlgorithm) {
        return this.getASN1ObjectIdentifier(digestAlgorithm.getOid());
    }

    private ASN1ObjectIdentifier getASN1ObjectIdentifier(String oid) {
        return new ASN1ObjectIdentifier(oid);
    }

    protected SignatureAlgorithm getSignatureAlgorithm() {
        EncryptionAlgorithm keyAlgorithm = EncryptionAlgorithm.forKey((Key)this.privateKey);
        if (this.encryptionAlgorithm != null) {
            if (!this.encryptionAlgorithm.isEquivalent(keyAlgorithm)) {
                throw new IllegalArgumentException(String.format("Defined EncryptionAlgorithm '%s' is not equivalent to the one returned by time-stamp issuer '%s'", this.encryptionAlgorithm, keyAlgorithm));
            }
            keyAlgorithm = this.encryptionAlgorithm;
        }
        return SignatureAlgorithm.getAlgorithm((EncryptionAlgorithm)keyAlgorithm, (DigestAlgorithm)this.digestAlgorithm);
    }

    protected TimeStampResponse generateResponse(TimeStampRequest request, DigestAlgorithm digestAlgorithm) throws TSPException {
        Date genTime = this.getProductionTime();
        TimeStampResponseGenerator responseGenerator = this.initResponseGenerator(digestAlgorithm, genTime);
        BigInteger timeStampSerialNumber = this.getTimeStampSerialNumber();
        return this.buildResponse(responseGenerator, request, timeStampSerialNumber, genTime);
    }

    protected TimeStampResponseGenerator initResponseGenerator(DigestAlgorithm digestAlgorithm, Date getTime) {
        try {
            SignatureAlgorithm signatureAlgorithm = this.getSignatureAlgorithm();
            ContentSigner signer = new JcaContentSignerBuilder(signatureAlgorithm.getJCEId()).build(this.privateKey);
            X509CertificateHolder certificateHolder = new X509CertificateHolder(this.certificate.getEncoded());
            SignerInfoGenerator infoGenerator = new SignerInfoGeneratorBuilder((DigestCalculatorProvider)new BcDigestCalculatorProvider()).setSignedAttributeGenerator(this.getSignedAttributeGenerator(getTime)).build(signer, certificateHolder);
            AlgorithmIdentifier digestAlgorithmIdentifier = new AlgorithmIdentifier(this.getASN1ObjectIdentifier(digestAlgorithm));
            DigestCalculator digestCalculator = new JcaDigestCalculatorProviderBuilder().build().get(digestAlgorithmIdentifier);
            TimeStampTokenGenerator tokenGenerator = new TimeStampTokenGenerator(infoGenerator, digestCalculator, this.getASN1ObjectIdentifier(this.tsaPolicy));
            tokenGenerator.addCertificates((Store)new JcaCertStore(this.certificateChain));
            return new TimeStampResponseGenerator(tokenGenerator, this.getAcceptedDigestAlgorithmIdentifiers());
        }
        catch (CertificateEncodingException | OperatorCreationException | TSPException e) {
            throw new DSSException(String.format("Unable to generate a timestamp. Reason : %s", e.getMessage()), e);
        }
        catch (IOException e) {
            throw new DSSException(String.format("An error occurred on timestamp response generation: %s", e.getMessage()), (Throwable)e);
        }
    }

    protected CMSAttributeTableGenerator getSignedAttributeGenerator(final Date getTime) {
        return new DefaultSignedAttributeTableGenerator(){

            protected Hashtable createStandardAttributeTable(Map map) {
                Hashtable hashtable = super.createStandardAttributeTable(map);
                if (getTime != null) {
                    Attribute attr = new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((ASN1Encodable)new Time(getTime)));
                    hashtable.put(CMSAttributes.signingTime, attr);
                }
                return hashtable;
            }
        };
    }

    protected TimeStampResponse buildResponse(TimeStampResponseGenerator responseGenerator, TimeStampRequest request, BigInteger timeStampSerialNumber, Date productionTime) throws TSPException {
        return responseGenerator.generate(request, timeStampSerialNumber, productionTime);
    }

    protected BigInteger getTimeStampSerialNumber() {
        return new BigInteger(128, this.secureRandom);
    }

    protected TimestampBinary getTimestampBinary(TimeStampResponse response) throws IOException {
        TimeStampToken timeStampToken = response.getTimeStampToken();
        if (timeStampToken != null) {
            return new TimestampBinary(timeStampToken.getEncoded());
        }
        if (response.getStatusString() != null) {
            throw new DSSException(String.format("Unable to generate a timestamp. Reason : %s", response.getStatusString()));
        }
        throw new DSSException("Unable to generate a timestamp. Response returned an empty time-stamp token.");
    }
}

