/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509;

import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.identifier.EntityIdentifier;
import eu.europa.esig.dss.model.identifier.KeyIdentifier;
import eu.europa.esig.dss.model.identifier.X500NameIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.X500PrincipalHelper;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.CertificateSourceEntity;
import eu.europa.esig.dss.spi.x509.CertificateTokenRefMatcher;
import eu.europa.esig.dss.spi.x509.EquivalentCertificatesEntity;
import eu.europa.esig.dss.spi.x509.SignerIdentifier;
import eu.europa.esig.dss.utils.Utils;
import java.security.Key;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonCertificateSource
implements CertificateSource {
    private static final long serialVersionUID = -5031898106342793626L;
    private static final Logger LOG = LoggerFactory.getLogger(CommonCertificateSource.class);
    protected final transient CertificateTokenRefMatcher certificateMatcher = new CertificateTokenRefMatcher();
    private Map<EntityIdentifier, EquivalentCertificatesEntity> entitiesByEntityKey = new HashMap<EntityIdentifier, EquivalentCertificatesEntity>();
    private Map<KeyIdentifier, EquivalentCertificatesEntity> entitiesByPublicKey = new HashMap<KeyIdentifier, EquivalentCertificatesEntity>();
    private Map<X500NameIdentifier, Set<CertificateToken>> tokensBySubject = new HashMap<X500NameIdentifier, Set<CertificateToken>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CertificateToken addCertificate(CertificateToken certificateToAdd) {
        EquivalentCertificatesEntity poolEntity;
        Objects.requireNonNull(certificateToAdd, "The certificate must be filled");
        if (LOG.isTraceEnabled()) {
            LOG.trace("Certificate to add: {} | {}", (Object)certificateToAdd.getIssuerX500Principal(), (Object)certificateToAdd.getSerialNumber());
        }
        Map<Object, Object> map = this.entitiesByEntityKey;
        synchronized (map) {
            EntityIdentifier entityKey = certificateToAdd.getEntityKey();
            poolEntity = this.entitiesByEntityKey.get(entityKey);
            if (poolEntity == null) {
                LOG.trace("Entity key {} is not in the pool", (Object)entityKey);
                poolEntity = new EquivalentCertificatesEntity(certificateToAdd);
                this.entitiesByEntityKey.put(entityKey, poolEntity);
            } else {
                LOG.trace("Entity key {} is already in the pool", (Object)entityKey);
                poolEntity.addEquivalentCertificate(certificateToAdd);
            }
        }
        map = this.entitiesByPublicKey;
        synchronized (map) {
            KeyIdentifier keyIdentifier = new KeyIdentifier((Key)certificateToAdd.getPublicKey());
            poolEntity = this.entitiesByPublicKey.get(keyIdentifier);
            if (poolEntity == null) {
                LOG.trace("Key identifier {} is not in the pool", (Object)keyIdentifier);
                poolEntity = new EquivalentCertificatesEntity(certificateToAdd);
                this.entitiesByPublicKey.put(keyIdentifier, poolEntity);
            } else {
                LOG.trace("Key identifier {} is already in the pool", (Object)keyIdentifier);
                poolEntity.addEquivalentCertificate(certificateToAdd);
            }
        }
        map = this.tokensBySubject;
        synchronized (map) {
            X500NameIdentifier x500NameIdentifier = new X500NameIdentifier(certificateToAdd.getSubject().getPrincipal());
            this.tokensBySubject.computeIfAbsent(x500NameIdentifier, k -> new HashSet()).add(certificateToAdd);
        }
        return certificateToAdd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCertificate(CertificateToken certificateToRemove) {
        EquivalentCertificatesEntity poolEntity;
        Objects.requireNonNull(certificateToRemove, "The certificate must be filled");
        if (LOG.isTraceEnabled()) {
            LOG.trace("Certificate to remove: {} | {}", (Object)certificateToRemove.getIssuerX500Principal(), (Object)certificateToRemove.getSerialNumber());
        }
        Map<Object, Object> map = this.entitiesByEntityKey;
        synchronized (map) {
            EntityIdentifier entityKey = certificateToRemove.getEntityKey();
            poolEntity = this.entitiesByEntityKey.get(entityKey);
            if (poolEntity == null) {
                LOG.trace("Entity key {} is not in the pool", (Object)entityKey);
            } else {
                LOG.trace("Entity key {} is in the pool", (Object)entityKey);
                if (poolEntity.getEquivalentCertificates().size() == 1) {
                    LOG.trace("Remove the entity key {} from the pool", (Object)entityKey);
                    this.entitiesByEntityKey.remove(entityKey);
                } else {
                    LOG.trace("Remove the token {} from the pool", (Object)certificateToRemove.getAbbreviation());
                    poolEntity.removeEquivalentCertificate(certificateToRemove);
                }
            }
        }
        map = this.entitiesByPublicKey;
        synchronized (map) {
            KeyIdentifier keyIdentifier = new KeyIdentifier((Key)certificateToRemove.getPublicKey());
            poolEntity = this.entitiesByPublicKey.get(keyIdentifier);
            if (poolEntity == null) {
                LOG.trace("Key identifier {} is not in the pool", (Object)keyIdentifier);
            } else {
                LOG.trace("Key identifier {} is in the pool", (Object)keyIdentifier);
                if (poolEntity.getEquivalentCertificates().size() == 1) {
                    LOG.trace("Remove the Key identifier {} from the pool", (Object)keyIdentifier);
                    this.entitiesByPublicKey.remove(keyIdentifier);
                } else {
                    LOG.trace("Remove the token {} from the pool", (Object)certificateToRemove.getAbbreviation());
                    poolEntity.removeEquivalentCertificate(certificateToRemove);
                }
            }
        }
        map = this.tokensBySubject;
        synchronized (map) {
            X500NameIdentifier x500NameIdentifier = new X500NameIdentifier(certificateToRemove.getSubject().getPrincipal());
            Set<CertificateToken> certificateTokens = this.tokensBySubject.get(x500NameIdentifier);
            if (Utils.isCollectionEmpty(certificateTokens)) {
                LOG.trace("RDN {} is not in the pool", (Object)x500NameIdentifier);
            } else if (certificateTokens.size() == 1) {
                this.tokensBySubject.remove(x500NameIdentifier);
            } else {
                certificateTokens.remove(certificateToRemove);
            }
        }
    }

    protected void reset() {
        this.entitiesByEntityKey = new HashMap<EntityIdentifier, EquivalentCertificatesEntity>();
        this.entitiesByPublicKey = new HashMap<KeyIdentifier, EquivalentCertificatesEntity>();
        this.tokensBySubject = new HashMap<X500NameIdentifier, Set<CertificateToken>>();
    }

    @Override
    public boolean isKnown(CertificateToken token) {
        EquivalentCertificatesEntity poolEntity = this.entitiesByEntityKey.get(token.getEntityKey());
        if (poolEntity != null) {
            Set<CertificateToken> certsByPublicKey = poolEntity.getEquivalentCertificates();
            Set<CertificateToken> certsBySubject = this.getBySubject(token.getSubject());
            return Utils.containsAny(certsByPublicKey, certsBySubject);
        }
        return false;
    }

    @Override
    public List<CertificateToken> getCertificates() {
        ArrayList<CertificateToken> allCertificates = new ArrayList<CertificateToken>();
        for (EquivalentCertificatesEntity entity : this.entitiesByEntityKey.values()) {
            allCertificates.addAll(entity.getEquivalentCertificates());
        }
        return Collections.unmodifiableList(allCertificates);
    }

    @Override
    public List<CertificateSourceEntity> getEntities() {
        return new ArrayList<CertificateSourceEntity>(this.entitiesByEntityKey.values());
    }

    @Override
    public Set<CertificateToken> getByPublicKey(PublicKey publicKey) {
        EquivalentCertificatesEntity entity = this.entitiesByPublicKey.get(new KeyIdentifier((Key)publicKey));
        if (entity != null) {
            return entity.getEquivalentCertificates();
        }
        return Collections.emptySet();
    }

    @Override
    public Set<CertificateToken> getByEntityKey(EntityIdentifier entityKey) {
        EquivalentCertificatesEntity entity = this.entitiesByEntityKey.get(entityKey);
        if (entity != null) {
            return entity.getEquivalentCertificates();
        }
        return Collections.emptySet();
    }

    @Override
    public Set<CertificateToken> getBySki(byte[] ski) {
        for (EquivalentCertificatesEntity entity : this.entitiesByPublicKey.values()) {
            if (!Arrays.equals(entity.getSki(), ski)) continue;
            return entity.getEquivalentCertificates();
        }
        return Collections.emptySet();
    }

    @Override
    public Set<CertificateToken> getBySubject(X500PrincipalHelper subject) {
        Set<CertificateToken> tokensSet = this.tokensBySubject.get(new X500NameIdentifier(subject.getPrincipal()));
        if (tokensSet != null) {
            return tokensSet;
        }
        return Collections.emptySet();
    }

    @Override
    public Set<CertificateToken> getBySignerIdentifier(SignerIdentifier signerIdentifier) {
        HashSet<CertificateToken> result = new HashSet<CertificateToken>();
        for (EquivalentCertificatesEntity entry : this.entitiesByEntityKey.values()) {
            for (CertificateToken certificateToken : entry.getEquivalentCertificates()) {
                if (!signerIdentifier.isRelatedToCertificate(certificateToken)) continue;
                result.add(certificateToken);
            }
        }
        return result;
    }

    @Override
    public Set<CertificateToken> getByCertificateDigest(Digest digest) {
        HashSet<CertificateToken> result = new HashSet<CertificateToken>();
        for (EquivalentCertificatesEntity entry : this.entitiesByEntityKey.values()) {
            for (CertificateToken certificateToken : entry.getEquivalentCertificates()) {
                if (!Arrays.equals(digest.getValue(), certificateToken.getDigest(digest.getAlgorithm()))) continue;
                result.add(certificateToken);
            }
        }
        return result;
    }

    @Override
    public Set<CertificateToken> findTokensFromCertRef(CertificateRef certificateRef) {
        HashSet<CertificateToken> result = new HashSet<CertificateToken>();
        for (EquivalentCertificatesEntity entry : this.entitiesByEntityKey.values()) {
            for (CertificateToken certificateToken : entry.getEquivalentCertificates()) {
                if (!this.doesCertificateReferenceMatch(certificateToken, certificateRef)) continue;
                result.add(certificateToken);
            }
        }
        return result;
    }

    protected boolean doesCertificateReferenceMatch(CertificateToken certificateToken, CertificateRef certificateRef) {
        return this.certificateMatcher.match(certificateToken, certificateRef);
    }

    public int getNumberOfCertificates() {
        return this.getCertificates().size();
    }

    public int getNumberOfEntities() {
        return this.entitiesByEntityKey.size();
    }

    @Override
    public CertificateSourceType getCertificateSourceType() {
        return CertificateSourceType.OTHER;
    }

    @Override
    public boolean isTrusted(CertificateToken certificateToken) {
        return false;
    }

    @Override
    public boolean isTrustedAtTime(CertificateToken certificateToken, Date controlTime) {
        return this.isTrusted(certificateToken);
    }

    @Override
    public boolean isAllSelfSigned() {
        for (CertificateToken certificate : this.getCertificates()) {
            if (certificate.isSelfSigned()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCertificateSourceEqual(CertificateSource certificateSource) {
        return new HashSet<CertificateToken>(this.getCertificates()).equals(new HashSet<CertificateToken>(certificateSource.getCertificates()));
    }

    @Override
    public boolean isCertificateSourceEquivalent(CertificateSource certificateSource) {
        return new HashSet<CertificateSourceEntity>(this.getEntities()).equals(new HashSet<CertificateSourceEntity>(certificateSource.getEntities()));
    }
}

