/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.validation.scope;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.utils.Utils;
import java.util.List;

public abstract class SignatureScopeWithTransformations
extends SignatureScope {
    private static final long serialVersionUID = -7049827869970167023L;
    private final List<String> transformations;

    protected SignatureScopeWithTransformations(DSSDocument document, List<String> transformations) {
        this(document.getName(), document, transformations);
    }

    protected SignatureScopeWithTransformations(String name, DSSDocument document, List<String> transformations) {
        super(name, document);
        this.transformations = transformations;
    }

    protected String addTransformationIfNeeded(String description) {
        if (Utils.isCollectionNotEmpty(this.transformations)) {
            description = description + " with transformations.";
        }
        return description;
    }

    public List<String> getTransformations() {
        return this.transformations;
    }

    public String toString() {
        return "SignatureScopeWithTransformations{transformations=" + this.transformations + "} " + super.toString();
    }
}

