/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.validation.executor;

import eu.europa.esig.dss.spi.validation.SignatureValidationAlerter;
import eu.europa.esig.dss.spi.validation.SignatureValidationContext;
import eu.europa.esig.dss.spi.validation.ValidationContext;
import eu.europa.esig.dss.spi.validation.executor.ValidationContextExecutor;
import java.util.Objects;

public final class CompleteValidationContextExecutor
implements ValidationContextExecutor {
    public static final CompleteValidationContextExecutor INSTANCE = new CompleteValidationContextExecutor();

    private CompleteValidationContextExecutor() {
    }

    @Override
    public void validate(ValidationContext validationContext) {
        CompleteValidationContextExecutor.assertValidationContextSupported(validationContext);
        validationContext.validate();
        this.assertSignaturesValid(validationContext);
    }

    private void assertSignaturesValid(ValidationContext validationContext) {
        SignatureValidationAlerter validationAlerter = new SignatureValidationAlerter((SignatureValidationContext)validationContext);
        validationAlerter.assertAllTimestampsValid();
        validationAlerter.assertAllRequiredRevocationDataPresent();
        validationAlerter.assertAllPOECoveredByRevocationData();
        validationAlerter.assertAllSignaturesAreYetValid();
        validationAlerter.assertAllSignaturesNotExpired();
        validationAlerter.assertAllSignatureCertificatesNotRevoked();
        validationAlerter.assertAllSignatureCertificateHaveFreshRevocationData();
    }

    private static void assertValidationContextSupported(ValidationContext validationContext) {
        Objects.requireNonNull(validationContext, "ValidationContext cannot be null!");
        if (!(validationContext instanceof SignatureValidationContext)) {
            throw new UnsupportedOperationException("CompleteValidationContextExecutor supports only SignatureValidationContext class type!");
        }
    }
}

