/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.validation.evidencerecord;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.SignatureAttribute;
import eu.europa.esig.dss.spi.validation.evidencerecord.SignatureEvidenceRecordDigestBuilder;
import java.util.Objects;

public abstract class AbstractSignatureEvidenceRecordDigestBuilder
implements SignatureEvidenceRecordDigestBuilder {
    protected final DSSDocument signatureDocument;
    protected final DigestAlgorithm digestAlgorithm;
    protected final AdvancedSignature signature;
    protected final SignatureAttribute evidenceRecordAttribute;
    protected boolean parallelEvidenceRecord;

    protected AbstractSignatureEvidenceRecordDigestBuilder(DSSDocument signatureDocument) {
        this(signatureDocument, DigestAlgorithm.SHA256);
    }

    protected AbstractSignatureEvidenceRecordDigestBuilder(DSSDocument signatureDocument, DigestAlgorithm digestAlgorithm) {
        Objects.requireNonNull(signatureDocument, "Signature document cannot be null!");
        Objects.requireNonNull(digestAlgorithm, "DigestAlgorithm cannot be null!");
        this.signatureDocument = signatureDocument;
        this.digestAlgorithm = digestAlgorithm;
        this.signature = null;
        this.evidenceRecordAttribute = null;
    }

    protected AbstractSignatureEvidenceRecordDigestBuilder(AdvancedSignature signature, SignatureAttribute evidenceRecordAttribute, DigestAlgorithm digestAlgorithm) {
        Objects.requireNonNull(signature, "Signature cannot be null!");
        Objects.requireNonNull(digestAlgorithm, "DigestAlgorithm cannot be null!");
        this.signature = signature;
        this.evidenceRecordAttribute = evidenceRecordAttribute;
        this.digestAlgorithm = digestAlgorithm;
        this.signatureDocument = null;
    }

    public AbstractSignatureEvidenceRecordDigestBuilder setParallelEvidenceRecord(boolean parallelEvidenceRecord) {
        this.parallelEvidenceRecord = parallelEvidenceRecord;
        return this;
    }

    protected Digest getDigest(DSSDocument document) {
        return new Digest(this.digestAlgorithm, document.getDigestValue(this.digestAlgorithm));
    }
}

