/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.validation;

import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.utils.Utils;
import java.util.Date;
import java.util.List;

public class TrustAnchorVerifier {
    private CertificateSource trustedCertificateSource;
    private boolean acceptTimestampUntrustedCertificateChains;
    private boolean acceptRevocationUntrustedCertificateChains;
    private boolean useSunsetDate;

    protected TrustAnchorVerifier() {
    }

    public static TrustAnchorVerifier createEmptyTrustAnchorVerifier() {
        return new TrustAnchorVerifier();
    }

    public static TrustAnchorVerifier createDefaultTrustAnchorVerifier() {
        TrustAnchorVerifier trustAnchorVerifier = new TrustAnchorVerifier();
        trustAnchorVerifier.setUseSunsetDate(true);
        return trustAnchorVerifier;
    }

    public boolean isAcceptTimestampUntrustedCertificateChains() {
        return this.acceptTimestampUntrustedCertificateChains;
    }

    public void setAcceptTimestampUntrustedCertificateChains(boolean acceptTimestampUntrustedCertificateChains) {
        this.acceptTimestampUntrustedCertificateChains = acceptTimestampUntrustedCertificateChains;
    }

    public boolean isAcceptRevocationUntrustedCertificateChains() {
        return this.acceptRevocationUntrustedCertificateChains;
    }

    public void setAcceptRevocationUntrustedCertificateChains(boolean acceptRevocationUntrustedCertificateChains) {
        this.acceptRevocationUntrustedCertificateChains = acceptRevocationUntrustedCertificateChains;
    }

    public CertificateSource getTrustedCertificateSource() {
        return this.trustedCertificateSource;
    }

    public void setTrustedCertificateSource(CertificateSource trustedCertificateSource) {
        this.trustedCertificateSource = trustedCertificateSource;
    }

    public boolean isUseSunsetDate() {
        return this.useSunsetDate;
    }

    public void setUseSunsetDate(boolean useSunsetDate) {
        this.useSunsetDate = useSunsetDate;
    }

    public boolean isTrustedAtTime(CertificateToken certificateToken, Date controlTime) {
        return this.isTrustedAtTime(certificateToken, controlTime, null);
    }

    public boolean isTrustedAtTime(CertificateToken certificateToken, Date controlTime, Context context) {
        if (this.isAcceptUntrustedCertificateChains(context)) {
            return true;
        }
        if (this.trustedCertificateSource == null) {
            return false;
        }
        if (this.useSunsetDate && controlTime != null) {
            return this.trustedCertificateSource.isTrustedAtTime(certificateToken, controlTime);
        }
        return this.trustedCertificateSource.isTrusted(certificateToken);
    }

    public boolean isTrustedCertificateChain(List<CertificateToken> certChain, Date controlTime) {
        return this.isTrustedCertificateChain(certChain, controlTime, null);
    }

    public boolean isTrustedCertificateChain(List<CertificateToken> certChain, Date controlTime, Context context) {
        if (this.isAcceptUntrustedCertificateChains(context)) {
            return true;
        }
        if (Utils.isCollectionNotEmpty(certChain)) {
            for (CertificateToken token : certChain) {
                if (!this.isTrustedAtTime(token, controlTime, context)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAcceptUntrustedCertificateChains(Context context) {
        if (Context.TIMESTAMP == context) {
            return this.acceptTimestampUntrustedCertificateChains;
        }
        if (Context.REVOCATION == context) {
            return this.acceptRevocationUntrustedCertificateChains;
        }
        return false;
    }
}

