/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.tsl;

import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.model.identifier.EntityIdentifier;
import eu.europa.esig.dss.model.tsl.CertificateTrustTime;
import eu.europa.esig.dss.model.tsl.TLValidationJobSummary;
import eu.europa.esig.dss.model.tsl.TrustProperties;
import eu.europa.esig.dss.model.tsl.TrustPropertiesCertificateSource;
import eu.europa.esig.dss.model.tsl.TrustServiceStatusAndInformationExtensions;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.x509.CommonTrustedCertificateSource;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustedListsCertificateSource
extends CommonTrustedCertificateSource
implements TrustPropertiesCertificateSource {
    private static final Logger LOG = LoggerFactory.getLogger(TrustedListsCertificateSource.class);
    private TLValidationJobSummary summary;
    private Map<EntityIdentifier, List<TrustProperties>> trustPropertiesByEntity = new HashMap<EntityIdentifier, List<TrustProperties>>();
    private Map<EntityIdentifier, List<CertificateTrustTime>> trustTimeByEntity = new HashMap<EntityIdentifier, List<CertificateTrustTime>>();

    public TLValidationJobSummary getSummary() {
        return this.summary;
    }

    public void setSummary(TLValidationJobSummary summary) {
        this.summary = summary;
    }

    @Override
    public CertificateSourceType getCertificateSourceType() {
        return CertificateSourceType.TRUSTED_LIST;
    }

    @Override
    public CertificateToken addCertificate(CertificateToken certificate) {
        throw new UnsupportedOperationException("Cannot directly add certificate to a TrustedListsCertificateSource");
    }

    public synchronized void setTrustPropertiesByCertificates(Map<CertificateToken, List<TrustProperties>> trustPropertiesByCerts) {
        Objects.requireNonNull(trustPropertiesByCerts, "TrustPropertiesByCerts cannot be null!");
        this.trustPropertiesByEntity = new HashMap<EntityIdentifier, List<TrustProperties>>();
        super.reset();
        trustPropertiesByCerts.forEach(this::addCertificate);
    }

    private void addCertificate(CertificateToken certificateToken, List<TrustProperties> trustPropertiesList) {
        super.addCertificate(certificateToken);
        Objects.requireNonNull(trustPropertiesList, "TrustPropertiesList must be filled");
        EntityIdentifier entityKey = certificateToken.getEntityKey();
        List list = this.trustPropertiesByEntity.computeIfAbsent(entityKey, k -> new ArrayList());
        for (TrustProperties trustProperties : trustPropertiesList) {
            if (list.contains(trustProperties)) continue;
            list.add(trustProperties);
        }
    }

    public synchronized List<TrustProperties> getTrustServices(CertificateToken token) {
        List<TrustProperties> currentTrustProperties = this.trustPropertiesByEntity.get(token.getEntityKey());
        if (currentTrustProperties != null) {
            return currentTrustProperties;
        }
        return Collections.emptyList();
    }

    public synchronized void setTrustTimeByCertificates(Map<CertificateToken, List<CertificateTrustTime>> trustTimeByCertificate) {
        Objects.requireNonNull(trustTimeByCertificate, "trustTimeByCertificate cannot be null!");
        this.trustTimeByEntity = new HashMap<EntityIdentifier, List<CertificateTrustTime>>();
        trustTimeByCertificate.forEach(this::addCertificateTrustTimes);
    }

    private void addCertificateTrustTimes(CertificateToken certificateToken, List<CertificateTrustTime> certificateTrustTimes) {
        super.addCertificate(certificateToken);
        Objects.requireNonNull(certificateTrustTimes, "CertificateTrustTimes must be filled");
        EntityIdentifier entityKey = certificateToken.getEntityKey();
        List list = this.trustTimeByEntity.computeIfAbsent(entityKey, k -> new ArrayList());
        for (CertificateTrustTime trustTime : certificateTrustTimes) {
            if (list.contains(trustTime)) continue;
            list.add(trustTime);
        }
    }

    public synchronized CertificateTrustTime getTrustTime(CertificateToken token) {
        if (!super.isTrusted(token)) {
            return new CertificateTrustTime(false);
        }
        List<CertificateTrustTime> trustTimes = this.trustTimeByEntity.get(token.getEntityKey());
        if (Utils.isCollectionNotEmpty(trustTimes)) {
            CertificateTrustTime certificateTrustTime = null;
            for (CertificateTrustTime trustTime : trustTimes) {
                if (certificateTrustTime == null || !certificateTrustTime.isTrusted()) {
                    certificateTrustTime = trustTime;
                    continue;
                }
                if (trustTime == null || !trustTime.isTrusted()) continue;
                certificateTrustTime = certificateTrustTime.getJointTrustTime(trustTime.getStartDate(), trustTime.getEndDate());
            }
            return certificateTrustTime;
        }
        return new CertificateTrustTime(true);
    }

    @Override
    public boolean isTrustedAtTime(CertificateToken certificateToken, Date controlTime) {
        CertificateTrustTime trustTime = this.getTrustTime(certificateToken);
        return trustTime.isTrustedAtTime(controlTime);
    }

    @Override
    public List<String> getAlternativeOCSPUrls(CertificateToken trustAnchor) {
        return this.getServiceSupplyPoints(trustAnchor, "ocsp");
    }

    @Override
    public List<String> getAlternativeCRLUrls(CertificateToken trustAnchor) {
        return this.getServiceSupplyPoints(trustAnchor, "crl", "certificateRevocationList");
    }

    private List<String> getServiceSupplyPoints(CertificateToken trustAnchor, String ... keywords) {
        ArrayList<String> urls = new ArrayList<String>();
        List<TrustProperties> trustPropertiesList = this.getTrustServices(trustAnchor);
        for (TrustProperties trustProperties : trustPropertiesList) {
            for (TrustServiceStatusAndInformationExtensions statusAndInfo : trustProperties.getTrustService()) {
                List serviceSupplyPoints = statusAndInfo.getServiceSupplyPoints();
                if (!Utils.isCollectionNotEmpty((Collection)serviceSupplyPoints)) continue;
                for (String serviceSupplyPoint : serviceSupplyPoints) {
                    for (String keyword : keywords) {
                        if (!serviceSupplyPoint.contains(keyword)) continue;
                        LOG.debug("ServiceSupplyPoints (TL) found for keyword '{}'", (Object)keyword);
                        urls.add(serviceSupplyPoint);
                    }
                }
            }
        }
        return urls;
    }

    @Override
    public boolean isTrusted(CertificateToken certificateToken) {
        if (super.isTrusted(certificateToken)) {
            CertificateTrustTime trustTime = this.getTrustTime(certificateToken);
            return trustTime == null || trustTime.isTrusted();
        }
        return false;
    }

    public int getNumberOfTrustedEntityKeys() {
        return this.trustPropertiesByEntity.size();
    }
}

