/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.policy;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.signature.SignaturePolicy;
import eu.europa.esig.dss.model.signature.SignaturePolicyValidationResult;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.policy.AbstractSignaturePolicyValidator;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.io.InputStream;

public class NonASN1SignaturePolicyValidator
extends AbstractSignaturePolicyValidator {
    @Override
    public boolean canValidate(SignaturePolicy signaturePolicy) {
        DSSDocument policyContent = signaturePolicy.getPolicyContent();
        if (policyContent != null) {
            byte firstByte = DSSUtils.readFirstByte(policyContent);
            return !DSSASN1Utils.isASN1SequenceTag(firstByte) && 60 != firstByte && !this.startsWithXmlBom(policyContent);
        }
        return false;
    }

    private boolean startsWithXmlBom(DSSDocument policyContent) {
        boolean bl;
        block8: {
            InputStream is = policyContent.openStream();
            try {
                bl = Utils.startsWith((InputStream)is, (byte[])new byte[]{-17, -69, -65, 60});
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DSSException("Cannot read the InputStream!", (Throwable)e);
                }
            }
            is.close();
        }
        return bl;
    }

    @Override
    public SignaturePolicyValidationResult validate(SignaturePolicy signaturePolicy) {
        SignaturePolicyValidationResult validationResult = new SignaturePolicyValidationResult();
        DSSDocument policyContent = signaturePolicy.getPolicyContent();
        if (policyContent == null) {
            validationResult.addError("general", "The signature policy content is not obtained.");
            return validationResult;
        }
        validationResult.setIdentified(true);
        Digest digest = signaturePolicy.getDigest();
        if (digest == null) {
            validationResult.addError("general", "The policy digest value is not defined.");
            return validationResult;
        }
        validationResult.setDigestAlgorithmsEqual(true);
        Digest recalculatedDigest = this.getComputedDigest(signaturePolicy.getPolicyContent(), digest.getAlgorithm());
        validationResult.setDigest(recalculatedDigest);
        if (digest.equals((Object)recalculatedDigest)) {
            validationResult.setDigestValid(true);
            validationResult.setDigestAlgorithmsEqual(true);
        } else {
            validationResult.addError("general", "The policy digest value (" + Utils.toBase64((byte[])digest.getValue()) + ") does not match the re-calculated digest value (" + Utils.toBase64((byte[])recalculatedDigest.getValue()) + ").");
        }
        return validationResult;
    }
}

