/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.client.http;

import eu.europa.esig.dss.spi.client.http.DataLoader;
import eu.europa.esig.dss.spi.client.http.NativeDataLoaderCall;
import eu.europa.esig.dss.spi.exception.DSSExternalResourceException;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeHTTPDataLoader
implements DataLoader {
    private static final long serialVersionUID = 4075489539157157286L;
    private static final Logger LOG = LoggerFactory.getLogger(NativeHTTPDataLoader.class);
    private int maxInputSize;
    private int connectTimeout = 0;
    private int readTimeout = 0;

    @Override
    public void setContentType(String contentType) {
        throw new UnsupportedOperationException("Content type change is not supported by this implementation!");
    }

    public int getMaxInputSize() {
        return this.maxInputSize;
    }

    public void setMaxInputSize(int maxInputSize) {
        this.maxInputSize = maxInputSize;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    protected byte[] request(String url, HttpMethod method, byte[] content, boolean refresh) {
        try {
            Callable<byte[]> task = this.createNativeDataLoaderCall(url, method, content, refresh);
            return task.call();
        }
        catch (DSSExternalResourceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DSSExternalResourceException(e);
        }
    }

    protected Callable<byte[]> createNativeDataLoaderCall(String url, HttpMethod method, byte[] content, boolean refresh) {
        return new NativeDataLoaderCall(url, content, !refresh, this.maxInputSize, this.connectTimeout, this.readTimeout);
    }

    @Override
    public DataLoader.DataAndUrl get(List<String> urlStrings) {
        for (String urlString : urlStrings) {
            try {
                byte[] bytes = this.get(urlString);
                if (bytes == null) continue;
                return new DataLoader.DataAndUrl(urlString, bytes);
            }
            catch (Exception e) {
                LOG.warn("Impossible to obtain data using {}", (Object)urlString, (Object)e);
            }
        }
        throw new DSSExternalResourceException(String.format("No data have been obtained from urls : %s", urlStrings));
    }

    @Override
    public byte[] get(String url) {
        return this.get(url, false);
    }

    public byte[] get(String url, boolean refresh) {
        return this.request(url, HttpMethod.GET, null, refresh);
    }

    @Override
    public byte[] post(String url, byte[] content) {
        return this.request(url, HttpMethod.POST, content, true);
    }

    protected static enum HttpMethod {
        GET,
        POST;

    }
}

