/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.revocation.crl;

import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.crl.CRLValidity;
import eu.europa.esig.dss.enumerations.CertificateStatus;
import eu.europa.esig.dss.enumerations.RevocationReason;
import eu.europa.esig.dss.enumerations.RevocationType;
import eu.europa.esig.dss.enumerations.SignatureValidity;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.revocation.RevocationCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.CRLReason;
import java.security.cert.X509CRLEntry;
import java.util.Objects;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRLToken
extends RevocationToken<CRL> {
    private static final long serialVersionUID = 1934492191629483078L;
    private static final Logger LOG = LoggerFactory.getLogger(CRLToken.class);
    private final CRLValidity crlValidity;

    public CRLToken(CertificateToken certificateToken, CRLValidity crlValidity) {
        Objects.requireNonNull(crlValidity, "CRL Validity cannot be null");
        this.crlValidity = crlValidity;
        this.relatedCertificate = certificateToken;
        this.initInfo();
        this.setRevocationStatus(certificateToken);
        if (LOG.isDebugEnabled()) {
            LOG.debug("A CRLToken created with Id : [{}]", (Object)this.getDSSIdAsString());
        }
    }

    private void initInfo() {
        this.signatureAlgorithm = this.crlValidity.getSignatureAlgorithm();
        this.thisUpdate = this.crlValidity.getThisUpdate();
        this.productionDate = this.crlValidity.getThisUpdate();
        this.nextUpdate = this.crlValidity.getNextUpdate();
        this.expiredCertsOnCRL = this.crlValidity.getExpiredCertsOnCRL();
        CertificateToken issuerToken = this.crlValidity.getIssuerToken();
        if (issuerToken != null) {
            this.publicKeyOfTheSigner = issuerToken.getPublicKey();
        }
        this.signatureValidity = SignatureValidity.get((Boolean)this.crlValidity.isSignatureIntact());
        this.signatureInvalidityReason = this.crlValidity.getSignatureInvalidityReason();
    }

    private void setRevocationStatus(CertificateToken certificateToken) {
        X500Principal issuerToken = certificateToken.getIssuerX500Principal();
        CertificateToken crlSigner = this.crlValidity.getIssuerToken();
        X500Principal crlSignerSubject = null;
        if (crlSigner != null) {
            crlSignerSubject = crlSigner.getSubject().getPrincipal();
        }
        if (!DSSASN1Utils.x500PrincipalAreEquals(issuerToken, crlSignerSubject)) {
            if (!this.crlValidity.isSignatureIntact()) {
                throw new DSSException(this.crlValidity.getSignatureInvalidityReason());
            }
            throw new DSSException("The CRLToken is not signed by the same issuer as the CertificateToken to be verified!");
        }
        BigInteger serialNumber = certificateToken.getSerialNumber();
        X509CRLEntry crlEntry = CRLUtils.getRevocationInfo((CRLValidity)this.crlValidity, (BigInteger)serialNumber);
        if (crlEntry != null) {
            this.status = CertificateStatus.REVOKED;
            this.revocationDate = crlEntry.getRevocationDate();
            CRLReason revocationReason = crlEntry.getRevocationReason();
            if (revocationReason != null) {
                this.reason = RevocationReason.fromInt((int)revocationReason.ordinal());
            }
        } else {
            this.status = CertificateStatus.GOOD;
        }
    }

    protected SignatureValidity checkIsSignedBy(PublicKey publicKey) {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName());
    }

    @Override
    public RevocationCertificateSource getCertificateSource() {
        return null;
    }

    public CRLValidity getCrlValidity() {
        return this.crlValidity;
    }

    public X500Principal getIssuerX500Principal() {
        if (this.crlValidity.getIssuerToken() != null) {
            return this.crlValidity.getIssuerToken().getSubject().getPrincipal();
        }
        return null;
    }

    @Override
    public CertificateToken getIssuerCertificateToken() {
        return this.crlValidity.getIssuerToken();
    }

    public byte[] getEncoded() {
        return this.crlValidity.getDerEncoded();
    }

    public InputStream getCRLStream() {
        return this.crlValidity.toCRLInputStream();
    }

    public boolean isValid() {
        return this.crlValidity.isValid();
    }

    @Override
    public RevocationType getRevocationType() {
        return RevocationType.CRL;
    }

    public String getAbbreviation() {
        return "CRLToken[" + (this.productionDate == null ? "?" : DSSUtils.formatDateToRFC(this.productionDate)) + ", signedBy=" + this.getIssuerX500Principal() + "]";
    }

    public String toString(String indentStr) {
        StringBuilder out = new StringBuilder();
        out.append(indentStr).append("CRLToken[\n");
        indentStr = indentStr + "\t";
        out.append(indentStr).append("Id: ").append(this.getDSSIdAsString()).append('\n');
        out.append(indentStr).append("Production time: ").append(this.productionDate == null ? "?" : DSSUtils.formatDateToRFC(this.productionDate)).append('\n');
        out.append(indentStr).append("NextUpdate time: ").append(this.nextUpdate == null ? "?" : DSSUtils.formatDateToRFC(this.nextUpdate)).append('\n');
        out.append(indentStr).append("Signature algorithm: ").append((Object)(this.signatureAlgorithm == null ? "?" : this.signatureAlgorithm)).append('\n');
        out.append(indentStr).append("Status: ").append(this.getStatus()).append('\n');
        out.append(indentStr).append("Issuer's certificate: ").append(this.getIssuerX500Principal()).append('\n');
        if (this.getRelatedCertificateId() != null) {
            out.append(indentStr).append("Related certificate: ").append(this.getRelatedCertificateId()).append('\n');
        }
        indentStr = indentStr.substring(1);
        out.append(indentStr).append(']');
        return out.toString();
    }
}

