/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.model.x509.X500PrincipalHelper;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenIssuerSelector {
    private static final Logger LOG = LoggerFactory.getLogger(TokenIssuerSelector.class);
    private final Token token;
    private final Collection<CertificateToken> certificateTokens;

    public TokenIssuerSelector(Token token, Collection<CertificateToken> certificateTokens) {
        this.token = token;
        this.certificateTokens = certificateTokens;
    }

    public CertificateToken getIssuer() {
        if (Utils.isCollectionNotEmpty(this.certificateTokens)) {
            Collection<CertificateToken> candidates = TokenIssuerSelector.filterIssuersByPublicKey(this.token, this.certificateTokens);
            candidates = TokenIssuerSelector.filterIssuersByIssuerSubjectName(this.token, candidates);
            for (CertificateToken candidate : candidates) {
                if (!candidate.isValidOn(this.token.getCreationDate())) continue;
                return candidate;
            }
            if (Utils.isCollectionNotEmpty(candidates)) {
                LOG.warn("No issuer found for the token creation date. The process continues with an issuer which has the same public key.");
                return candidates.iterator().next();
            }
        }
        return null;
    }

    private static Collection<CertificateToken> filterIssuersByPublicKey(Token token, Collection<CertificateToken> candidates) {
        ArrayList<CertificateToken> issuers = new ArrayList<CertificateToken>();
        for (CertificateToken candidate : candidates) {
            if (!token.isSignedBy(candidate)) continue;
            issuers.add(candidate);
        }
        return issuers;
    }

    private static Collection<CertificateToken> filterIssuersByIssuerSubjectName(Token token, Collection<CertificateToken> candidates) {
        ArrayList<CertificateToken> issuers = new ArrayList<CertificateToken>();
        X500Principal issuerX500Principal = token.getIssuerX500Principal();
        if (issuerX500Principal != null) {
            X500PrincipalHelper issuerX500PrincipalHelper = new X500PrincipalHelper(issuerX500Principal);
            for (CertificateToken candidate : candidates) {
                if (issuerX500PrincipalHelper.equals((Object)candidate.getSubject())) {
                    issuers.add(candidate);
                    continue;
                }
                LOG.info("The issuer subject name and subject name does not match (more details in debug mode).");
                if (!LOG.isDebugEnabled()) continue;
                LOG.info("CERT ISSUER    : {}", (Object)issuerX500PrincipalHelper.getCanonical());
                LOG.info("ISSUER SUBJECT : {}", (Object)candidate.getSubject().getCanonical());
            }
        }
        return Utils.isCollectionNotEmpty(issuers) ? issuers : candidates;
    }
}

