/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509;

import eu.europa.esig.dss.enumerations.CertificateOrigin;
import eu.europa.esig.dss.enumerations.CertificateRefOrigin;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.CommonCertificateSource;
import eu.europa.esig.dss.spi.x509.SignerIdentifier;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class TokenCertificateSource
extends CommonCertificateSource {
    private final Map<SignerIdentifier, List<CertificateOrigin>> certificateIdentifierOrigins = new LinkedHashMap<SignerIdentifier, List<CertificateOrigin>>();
    private final Map<CertificateToken, List<CertificateOrigin>> certificateOrigins = new LinkedHashMap<CertificateToken, List<CertificateOrigin>>();
    private final Map<CertificateRef, List<CertificateRefOrigin>> certificateRefOrigins = new LinkedHashMap<CertificateRef, List<CertificateRefOrigin>>();

    protected TokenCertificateSource() {
    }

    protected void addCertificateIdentifier(SignerIdentifier signerIdentifier, CertificateOrigin origin) {
        Objects.requireNonNull(signerIdentifier, "The certificate identifier cannot be null");
        Objects.requireNonNull(origin, "The origin cannot be null");
        this.certificateIdentifierOrigins.computeIfAbsent(signerIdentifier, k -> new ArrayList()).add(origin);
    }

    protected void addCertificate(CertificateToken certificate, CertificateOrigin origin) {
        Objects.requireNonNull(certificate, "The certificate cannot be null");
        Objects.requireNonNull(origin, "The origin cannot be null");
        this.certificateOrigins.computeIfAbsent(certificate, k -> new ArrayList()).add(origin);
        this.addCertificate(certificate);
    }

    protected void addCertificateRef(CertificateRef certificateRef, CertificateRefOrigin origin) {
        Objects.requireNonNull(certificateRef, "The certificateRef cannot be null");
        Objects.requireNonNull(origin, "The origin cannot be null");
        this.certificateRefOrigins.computeIfAbsent(certificateRef, k -> new ArrayList()).add(origin);
    }

    public List<CertificateRef> getReferencesForCertificateToken(CertificateToken certificateToken) {
        ArrayList<CertificateRef> result = new ArrayList<CertificateRef>();
        for (CertificateRef certificateRef : this.certificateRefOrigins.keySet()) {
            if (!this.doesCertificateReferenceMatch(certificateToken, certificateRef)) continue;
            result.add(certificateRef);
        }
        return result;
    }

    public Set<CertificateToken> findTokensFromRefs(List<CertificateRef> certificateRefs) {
        HashSet<CertificateToken> result = new HashSet<CertificateToken>();
        for (CertificateRef certificateRef : certificateRefs) {
            result.addAll(this.findTokensFromCertRef(certificateRef));
        }
        return result;
    }

    public Set<SignerIdentifier> getAllCertificateIdentifiers() {
        return this.certificateIdentifierOrigins.keySet();
    }

    public SignerIdentifier getCurrentCertificateIdentifier() {
        SignerIdentifier current = null;
        for (SignerIdentifier signerIdentifier : this.getAllCertificateIdentifiers()) {
            if (!signerIdentifier.isCurrent()) continue;
            if (current != null) {
                throw new IllegalStateException("More than one current CertificateIdentifier");
            }
            current = signerIdentifier;
        }
        return current;
    }

    public Set<CertificateRef> getAllCertificateRefs() {
        return this.certificateRefOrigins.keySet();
    }

    public List<CertificateRef> getOrphanCertificateRefs() {
        ArrayList<CertificateRef> result = new ArrayList<CertificateRef>();
        for (CertificateRef certificateRef : this.certificateRefOrigins.keySet()) {
            if (!this.isOrphan(certificateRef)) continue;
            result.add(certificateRef);
        }
        return result;
    }

    protected boolean isOrphan(CertificateRef certificateRef) {
        for (CertificateToken certificateToken : this.certificateOrigins.keySet()) {
            if (!this.doesCertificateReferenceMatch(certificateToken, certificateRef)) continue;
            return false;
        }
        return true;
    }

    protected CertificateToken getCertificateToken(SignerIdentifier signerIdentifier) {
        for (CertificateToken certificateToken : this.certificateOrigins.keySet()) {
            if (!signerIdentifier.isRelatedToCertificate(certificateToken)) continue;
            return certificateToken;
        }
        return null;
    }

    protected List<CertificateToken> getCertificateTokensByOrigin(CertificateOrigin origin) {
        LinkedList<CertificateToken> result = new LinkedList<CertificateToken>();
        for (Map.Entry<CertificateToken, List<CertificateOrigin>> entry : this.certificateOrigins.entrySet()) {
            List<CertificateOrigin> currentOrigins = entry.getValue();
            if (!Utils.isCollectionNotEmpty(currentOrigins) || !currentOrigins.contains(origin)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    protected List<CertificateRef> getCertificateRefsByOrigin(CertificateRefOrigin origin) {
        LinkedList<CertificateRef> result = new LinkedList<CertificateRef>();
        for (Map.Entry<CertificateRef, List<CertificateRefOrigin>> entry : this.certificateRefOrigins.entrySet()) {
            List<CertificateRefOrigin> currentOrigins = entry.getValue();
            if (!Utils.isCollectionNotEmpty(currentOrigins) || !currentOrigins.contains(origin)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public List<CertificateRefOrigin> getCertificateRefOrigins(CertificateRef certificateRef) {
        List<CertificateRefOrigin> origins = this.certificateRefOrigins.get(certificateRef);
        if (Utils.isCollectionNotEmpty(origins)) {
            return origins;
        }
        return Collections.emptyList();
    }
}

