/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.x509.CertificateValidity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CandidatesForSigningCertificate
implements Serializable {
    private static final long serialVersionUID = 7965288455045066076L;
    private CertificateValidity theCertificateValidity = null;
    private List<CertificateValidity> certificateValidityList = new ArrayList<CertificateValidity>();

    public List<CertificateValidity> getCertificateValidityList() {
        return this.certificateValidityList;
    }

    public boolean isEmpty() {
        return this.certificateValidityList.isEmpty();
    }

    public void add(CertificateValidity certificateValidity) {
        this.certificateValidityList.add(certificateValidity);
    }

    public void setTheCertificateValidity(CertificateValidity theCertificateValidity) {
        Objects.requireNonNull(theCertificateValidity, "The CertificateValidity cannot be null");
        if (!this.certificateValidityList.contains(theCertificateValidity)) {
            throw new DSSException("theSigningCertificateValidity must be the part of the candidates!");
        }
        this.theCertificateValidity = theCertificateValidity;
    }

    public CertificateValidity getTheCertificateValidity() {
        return this.theCertificateValidity;
    }

    public CertificateValidity getTheBestCandidate() {
        CertificateValidity firstCandidate = null;
        for (CertificateValidity certificateValidity : this.certificateValidityList) {
            if (firstCandidate == null) {
                firstCandidate = certificateValidity;
            }
            if (!certificateValidity.isValid()) continue;
            return certificateValidity;
        }
        CertificateValidity signerIdMatchCandidate = this.getBySignerIdMatch();
        if (signerIdMatchCandidate != null) {
            return signerIdMatchCandidate;
        }
        return firstCandidate;
    }

    private CertificateValidity getBySignerIdMatch() {
        for (CertificateValidity certificateValidity : this.certificateValidityList) {
            if (!certificateValidity.isSignerIdMatch()) continue;
            return certificateValidity;
        }
        return null;
    }
}

