/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.service.http.commons;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.service.http.commons.CommonsHttpClientResponseHandler;
import eu.europa.esig.dss.service.http.commons.HostConnection;
import eu.europa.esig.dss.service.http.commons.LdapURLUtils;
import eu.europa.esig.dss.service.http.commons.UserCredentials;
import eu.europa.esig.dss.service.http.proxy.ProxyConfig;
import eu.europa.esig.dss.service.http.proxy.ProxyProperties;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.client.http.DataLoader;
import eu.europa.esig.dss.spi.client.http.Protocol;
import eu.europa.esig.dss.spi.exception.DSSDataLoaderMultipleException;
import eu.europa.esig.dss.spi.exception.DSSExternalResourceException;
import eu.europa.esig.dss.utils.Utils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.net.ssl.HostnameVerifier;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.impl.routing.DefaultProxyRoutePlanner;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.reactor.ssl.SSLBufferMode;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonsDataLoader
implements DataLoader {
    private static final long serialVersionUID = -805432648564425522L;
    private static final Logger LOG = LoggerFactory.getLogger(CommonsDataLoader.class);
    private static final Timeout TIMEOUT_CONNECTION = CommonsDataLoader.toTimeoutMilliseconds(60000);
    private static final Timeout TIMEOUT_SOCKET = CommonsDataLoader.toTimeoutMilliseconds(60000);
    private static final int CONNECTIONS_MAX_TOTAL = 20;
    private static final int CONNECTIONS_MAX_PER_ROUTE = 2;
    private static final TimeValue CONNECTION_TIME_TO_LIVE = CommonsDataLoader.toTimeValueMilliseconds(60000);
    private static final String CONTENT_TYPE = "Content-Type";
    protected String contentType;
    private ProxyConfig proxyConfig;
    private Timeout timeoutConnection = TIMEOUT_CONNECTION;
    private Timeout timeoutConnectionRequest = TIMEOUT_CONNECTION;
    private Timeout timeoutResponse = TIMEOUT_CONNECTION;
    private Timeout timeoutSocket = TIMEOUT_SOCKET;
    private TimeValue connectionKeepAlive = CONNECTION_TIME_TO_LIVE;
    private int connectionsMaxTotal = 20;
    private int connectionsMaxPerRoute = 2;
    private TimeValue connectionTimeToLive = CONNECTION_TIME_TO_LIVE;
    private boolean redirectsEnabled = true;
    private boolean useSystemProperties = false;
    private Map<HostConnection, UserCredentials> authenticationMap;
    private List<String> targetPreferredAuthSchemes;
    private String sslProtocol;
    private DSSDocument sslKeystore;
    private String sslKeystoreType = KeyStore.getDefaultType();
    private char[] sslKeystorePassword = new char[0];
    private boolean loadKeyStoreAsTrustMaterial = false;
    private DSSDocument sslTruststore;
    private String sslTruststoreType = KeyStore.getDefaultType();
    private char[] sslTruststorePassword = new char[0];
    private transient TrustStrategy trustStrategy;
    private String[] supportedSSLProtocols;
    private String[] supportedSSLCipherSuites;
    private transient HostnameVerifier hostnameVerifier = new DefaultHostnameVerifier();
    private transient HttpRequestRetryStrategy retryStrategy;
    private boolean preemptiveAuthentication;
    private transient HttpClientResponseHandler<byte[]> httpClientResponseHandler = new CommonsHttpClientResponseHandler();
    private Collection<String> ldapTrustedHostnames;

    public CommonsDataLoader() {
    }

    public CommonsDataLoader(String contentType) {
        this.contentType = contentType;
    }

    public int getTimeoutConnection() {
        return this.timeoutConnection.toMillisecondsIntBound();
    }

    public void setTimeoutConnection(int timeoutConnection) {
        this.timeoutConnection = CommonsDataLoader.toTimeoutMilliseconds(timeoutConnection);
    }

    public int getTimeoutConnectionRequest() {
        return this.timeoutConnectionRequest.toMillisecondsIntBound();
    }

    public void setTimeoutConnectionRequest(int timeoutConnectionRequest) {
        this.timeoutConnectionRequest = CommonsDataLoader.toTimeoutMilliseconds(timeoutConnectionRequest);
    }

    public int getTimeoutResponse() {
        return this.timeoutResponse.toMillisecondsIntBound();
    }

    public void setTimeoutResponse(int timeoutResponse) {
        this.timeoutResponse = CommonsDataLoader.toTimeoutMilliseconds(timeoutResponse);
    }

    public int getTimeoutSocket() {
        return this.timeoutSocket.toMillisecondsIntBound();
    }

    public void setTimeoutSocket(int timeoutSocket) {
        this.timeoutSocket = CommonsDataLoader.toTimeoutMilliseconds(timeoutSocket);
    }

    public int getConnectionKeepAlive() {
        return this.connectionKeepAlive.toMillisecondsIntBound();
    }

    public void setConnectionKeepAlive(int connectionKeepAlive) {
        this.connectionKeepAlive = CommonsDataLoader.toTimeValueMilliseconds(connectionKeepAlive);
    }

    public int getConnectionsMaxTotal() {
        return this.connectionsMaxTotal;
    }

    public void setConnectionsMaxTotal(int connectionsMaxTotal) {
        this.connectionsMaxTotal = connectionsMaxTotal;
    }

    public int getConnectionsMaxPerRoute() {
        return this.connectionsMaxPerRoute;
    }

    public void setConnectionsMaxPerRoute(int connectionsMaxPerRoute) {
        this.connectionsMaxPerRoute = connectionsMaxPerRoute;
    }

    public int getConnectionTimeToLive() {
        return this.connectionTimeToLive.toMillisecondsIntBound();
    }

    public void setConnectionTimeToLive(int connectionTimeToLive) {
        this.connectionTimeToLive = CommonsDataLoader.toTimeValueMilliseconds(connectionTimeToLive);
    }

    public boolean isRedirectsEnabled() {
        return this.redirectsEnabled;
    }

    public void setRedirectsEnabled(boolean redirectsEnabled) {
        this.redirectsEnabled = redirectsEnabled;
    }

    public boolean isUseSystemProperties() {
        return this.useSystemProperties;
    }

    public void setUseSystemProperties(boolean useSystemProperties) {
        this.useSystemProperties = useSystemProperties;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public void setProxyConfig(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public void setSslKeystore(DSSDocument sslKeyStore) {
        this.sslKeystore = sslKeyStore;
    }

    public void setKeyStoreAsTrustMaterial(boolean loadKeyStoreAsTrustMaterial) {
        this.loadKeyStoreAsTrustMaterial = loadKeyStoreAsTrustMaterial;
    }

    public void setSslKeystoreType(String sslKeystoreType) {
        this.sslKeystoreType = sslKeystoreType;
    }

    public void setSslKeystorePassword(char[] sslKeystorePassword) {
        this.sslKeystorePassword = sslKeystorePassword;
    }

    public void setSslTruststore(DSSDocument sslTrustStore) {
        this.sslTruststore = sslTrustStore;
    }

    public void setSslTruststorePassword(char[] sslTruststorePassword) {
        this.sslTruststorePassword = sslTruststorePassword;
    }

    public void setSslTruststoreType(String sslTruststoreType) {
        this.sslTruststoreType = sslTruststoreType;
    }

    public Map<HostConnection, UserCredentials> getAuthenticationMap() {
        if (this.authenticationMap == null) {
            this.authenticationMap = new HashMap<HostConnection, UserCredentials>();
        }
        return this.authenticationMap;
    }

    public void setAuthenticationMap(Map<HostConnection, UserCredentials> authenticationMap) {
        this.authenticationMap = authenticationMap;
    }

    public CommonsDataLoader addAuthentication(HostConnection hostConnection, UserCredentials userCredentials) {
        Map<HostConnection, UserCredentials> currentAuthenticationMap = this.getAuthenticationMap();
        currentAuthenticationMap.put(hostConnection, userCredentials);
        return this;
    }

    public CommonsDataLoader addAuthentication(String host, int port, String scheme, String login, char[] password) {
        HostConnection hostConnection = new HostConnection(host, port, scheme);
        UserCredentials userCredentials = new UserCredentials(login, password);
        return this.addAuthentication(hostConnection, userCredentials);
    }

    public List<String> getTargetPreferredAuthSchemes() {
        return this.targetPreferredAuthSchemes;
    }

    public void setTargetPreferredAuthSchemes(List<String> targetPreferredAuthSchemes) {
        this.targetPreferredAuthSchemes = targetPreferredAuthSchemes;
    }

    public void setPreemptiveAuthentication(boolean preemptiveAuthentication) {
        this.preemptiveAuthentication = preemptiveAuthentication;
    }

    public void setRetryStrategy(HttpRequestRetryStrategy retryStrategy) {
        this.retryStrategy = retryStrategy;
    }

    public String[] getSupportedSSLProtocols() {
        return this.supportedSSLProtocols;
    }

    public void setSupportedSSLProtocols(String[] supportedSSLProtocols) {
        this.supportedSSLProtocols = supportedSSLProtocols;
    }

    public String[] getSupportedSSLCipherSuites() {
        return this.supportedSSLCipherSuites;
    }

    public void setSupportedSSLCipherSuites(String[] supportedSSLCipherSuites) {
        this.supportedSSLCipherSuites = supportedSSLCipherSuites;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public TrustStrategy getTrustStrategy() {
        return this.trustStrategy;
    }

    public void setTrustStrategy(TrustStrategy trustStrategy) {
        this.trustStrategy = trustStrategy;
    }

    public HttpClientResponseHandler<byte[]> getHttpClientResponseHandler() {
        return this.httpClientResponseHandler;
    }

    public void setHttpClientResponseHandler(HttpClientResponseHandler<byte[]> httpClientResponseHandler) {
        Objects.requireNonNull(httpClientResponseHandler, "HttpClientResponseHandler cannot be null!");
        this.httpClientResponseHandler = httpClientResponseHandler;
    }

    public void setLdapTrustedHostnames(Collection<String> ldapTrustedHostnames) {
        this.ldapTrustedHostnames = ldapTrustedHostnames;
    }

    public byte[] get(String urlString) {
        if (Protocol.isFileUrl((String)urlString)) {
            return this.fileGet(urlString);
        }
        if (Protocol.isHttpUrl((String)urlString)) {
            return this.httpGet(urlString);
        }
        if (Protocol.isFtpUrl((String)urlString)) {
            return this.ftpGet(urlString);
        }
        if (Protocol.isLdapUrl((String)urlString)) {
            return this.ldapGet(urlString);
        }
        LOG.warn("DSS framework only supports FILE, HTTP, HTTPS, FTP and LDAP Urls.");
        return this.httpGet(urlString);
    }

    public DataLoader.DataAndUrl get(List<String> urlStrings) {
        if (Utils.isCollectionEmpty(urlStrings)) {
            throw new DSSExternalResourceException("Cannot process the GET call. List of URLs is empty!");
        }
        HashMap<String, Exception> exceptions = new HashMap<String, Exception>();
        for (String urlString : urlStrings) {
            LOG.debug("Processing a GET call to URL [{}]...", (Object)urlString);
            try {
                byte[] bytes = this.get(urlString);
                if (Utils.isArrayEmpty((byte[])bytes)) {
                    LOG.debug("The retrieved content from URL [{}] is empty. Continue with other URLs...", (Object)urlString);
                    continue;
                }
                return new DataLoader.DataAndUrl(urlString, bytes);
            }
            catch (Exception e) {
                LOG.warn("Cannot obtain data using '{}' : {}", (Object)urlString, (Object)e.getMessage());
                exceptions.put(urlString, e);
            }
        }
        throw new DSSDataLoaderMultipleException(exceptions);
    }

    protected byte[] ldapGet(String urlString) {
        String host = LdapURLUtils.getHost(urlString);
        if (this.ldapTrustedHostnames != null && !this.ldapTrustedHostnames.contains(host)) {
            throw new DSSExternalResourceException(String.format("Cannot get data from URL [%s]. Reason : [Untrusted host name '%s']", urlString, host));
        }
        urlString = LdapURLUtils.encode(urlString);
        Hashtable<String, String> env = this.initLdapContextEnvironment();
        env.put("java.naming.provider.url", urlString);
        try {
            InitialDirContext ctx;
            Attributes attributes;
            String attributeName;
            String ldapParams = Utils.substringAfter((String)urlString, (String)"?");
            StringTokenizer tokenizer = new StringTokenizer(ldapParams, "?");
            String string = attributeName = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
            if (Utils.isStringEmpty((String)attributeName)) {
                attributeName = "certificateRevocationList;binary";
            }
            if ((attributes = (ctx = new InitialDirContext(env)).getAttributes("", new String[]{attributeName})) == null || attributes.size() < 1) {
                throw new DSSExternalResourceException(String.format("Cannot download binaries from: [%s], no attributes with name: [%s] returned", urlString, attributeName));
            }
            Attribute attribute = attributes.getAll().next();
            byte[] ldapBytes = (byte[])attribute.get();
            if (Utils.isArrayNotEmpty((byte[])ldapBytes)) {
                return ldapBytes;
            }
            throw new DSSExternalResourceException(String.format("The retrieved ldap content from url [%s] is empty", urlString));
        }
        catch (DSSExternalResourceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DSSExternalResourceException(String.format("Cannot get data from URL [%s]. Reason : [%s]", urlString, e.getMessage()), (Throwable)e);
        }
    }

    protected Hashtable<String, String> initLdapContextEnvironment() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        return env;
    }

    protected byte[] ftpGet(String urlString) {
        byte[] byArray;
        block8: {
            URL url = this.getURL(urlString);
            InputStream inputStream = url.openStream();
            try {
                byArray = DSSUtils.toByteArray((InputStream)inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DSSExternalResourceException(String.format("Unable to retrieve file from URL %s. Reason : [%s]", urlString, e.getMessage()), (Throwable)e);
                }
            }
            inputStream.close();
        }
        return byArray;
    }

    protected byte[] fileGet(String urlString) {
        return this.ftpGet(urlString);
    }

    private URL getURL(String urlString) {
        try {
            return URI.create(urlString).toURL();
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            throw new DSSExternalResourceException("Unable to create URL instance", (Throwable)e);
        }
    }

    protected byte[] httpGet(String url) {
        HttpGet httpRequest = null;
        CloseableHttpClient client = null;
        try {
            httpRequest = this.getHttpRequest(url);
            client = this.getHttpClient(url);
            byte[] byArray = this.execute(client, (HttpUriRequest)httpRequest);
            this.closeQuietly((HttpUriRequestBase)httpRequest, client);
            return byArray;
        }
        catch (IOException | URISyntaxException e) {
            try {
                throw new DSSExternalResourceException(String.format("Unable to process GET call for url [%s]. Reason : [%s]", url, DSSUtils.getExceptionMessage((Exception)e)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.closeQuietly((HttpUriRequestBase)httpRequest, client);
                throw throwable;
            }
        }
    }

    /*
     * Exception decompiling
     */
    public byte[] post(String url, byte[] content) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected byte[] execute(CloseableHttpClient client, HttpUriRequest httpRequest) throws IOException {
        HttpHost targetHost = this.getHttpHost(httpRequest);
        HttpContext localContext = this.getHttpContext(targetHost);
        HttpClientResponseHandler<byte[]> responseHandler = this.getHttpClientResponseHandler();
        return (byte[])client.execute(targetHost, (ClassicHttpRequest)httpRequest, localContext, responseHandler);
    }

    protected HttpHost getHttpHost(HttpUriRequest httpRequest) {
        try {
            URI uri = httpRequest.getUri();
            return new HttpHost(uri.getScheme(), uri.getHost(), uri.getPort());
        }
        catch (URISyntaxException e) {
            throw new DSSExternalResourceException(String.format("Invalid URI : %s", e.getMessage()), (Throwable)e);
        }
    }

    protected HttpContext getHttpContext(HttpHost httpHost) {
        HttpClientContext localContext = HttpClientContext.create();
        localContext = this.configurePreemptiveAuthentication(localContext, httpHost);
        return localContext;
    }

    protected HttpClientContext configurePreemptiveAuthentication(HttpClientContext localContext, HttpHost httpHost) {
        if (this.preemptiveAuthentication && Utils.isMapNotEmpty(this.getAuthenticationMap())) {
            Credentials credentials = this.getCredentialsProvider().getCredentials(new AuthScope(httpHost), (HttpContext)localContext);
            BasicScheme basicScheme = new BasicScheme();
            basicScheme.initPreemptive(credentials);
            localContext.resetAuthExchange(httpHost, (AuthScheme)basicScheme);
        }
        return localContext;
    }

    protected void closeQuietly(HttpUriRequestBase httpRequest, CloseableHttpClient client) {
        try {
            if (httpRequest != null) {
                httpRequest.cancel();
            }
        }
        finally {
            Utils.closeQuietly((Closeable)client);
        }
    }

    protected HttpClientConnectionManager getConnectionManager() {
        PoolingHttpClientConnectionManagerBuilder builder = PoolingHttpClientConnectionManagerBuilder.create().setTlsSocketStrategy(this.getTlsSocketStrategy()).setDefaultSocketConfig(this.getSocketConfig()).setMaxConnTotal(this.getConnectionsMaxTotal()).setMaxConnPerRoute(this.getConnectionsMaxPerRoute());
        ConnectionConfig.Builder connectionConfigBuilder = ConnectionConfig.custom().setConnectTimeout(this.timeoutConnection).setTimeToLive(this.connectionTimeToLive);
        PoolingHttpClientConnectionManager connectionManager = builder.build();
        connectionManager.setDefaultConnectionConfig(connectionConfigBuilder.build());
        LOG.debug("PoolingHttpClientConnectionManager: max total: {}", (Object)connectionManager.getMaxTotal());
        LOG.debug("PoolingHttpClientConnectionManager: max per route: {}", (Object)connectionManager.getDefaultMaxPerRoute());
        return connectionManager;
    }

    protected SocketConfig getSocketConfig() {
        SocketConfig.Builder socketConfigBuilder = SocketConfig.custom();
        socketConfigBuilder.setSoTimeout(this.timeoutSocket);
        return socketConfigBuilder.build();
    }

    protected SSLContextBuilder getSSLContextBuilder() {
        try {
            KeyStore sslKeyStore;
            KeyStore sslTrustStore;
            SSLContextBuilder sslContextBuilder = SSLContextBuilder.create();
            sslContextBuilder.setProtocol(this.sslProtocol);
            if (this.trustStrategy != null) {
                LOG.debug("Set the TrustStrategy");
                sslContextBuilder.loadTrustMaterial(null, this.trustStrategy);
            }
            if ((sslTrustStore = this.getSSLTrustStore()) != null) {
                LOG.debug("Set the SSL trust store as trust materials");
                sslContextBuilder.loadTrustMaterial(sslTrustStore, this.trustStrategy);
            }
            if ((sslKeyStore = this.getSSLKeyStore()) != null) {
                LOG.debug("Set the SSL keystore as key materials");
                sslContextBuilder.loadKeyMaterial(sslKeyStore, this.sslKeystorePassword);
                if (this.loadKeyStoreAsTrustMaterial) {
                    LOG.debug("Set the SSL keystore as trust materials");
                    sslContextBuilder.loadTrustMaterial(sslKeyStore, this.trustStrategy);
                }
            }
            return sslContextBuilder;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to configure the SSLContext", e);
        }
    }

    protected TlsSocketStrategy getTlsSocketStrategy() {
        try {
            return new DefaultClientTlsStrategy(this.getSSLContextBuilder().build(), this.getSupportedSSLProtocols(), this.getSupportedSSLCipherSuites(), SSLBufferMode.STATIC, this.getHostnameVerifier());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to configure the TLSSocketStrategy", e);
        }
    }

    protected KeyStore getSSLKeyStore() throws IOException, GeneralSecurityException {
        return this.loadKeyStore(this.sslKeystore, this.sslKeystoreType, this.sslKeystorePassword);
    }

    protected KeyStore getSSLTrustStore() throws IOException, GeneralSecurityException {
        return this.loadKeyStore(this.sslTruststore, this.sslTruststoreType, this.sslTruststorePassword);
    }

    private KeyStore loadKeyStore(DSSDocument store, String type, char[] password) throws IOException, GeneralSecurityException {
        if (store != null) {
            try (InputStream is = store.openStream();){
                KeyStore ks = KeyStore.getInstance(type);
                ks.load(is, password);
                KeyStore keyStore = ks;
                return keyStore;
            }
        }
        return null;
    }

    protected synchronized HttpGet getHttpRequest(String url) throws URISyntaxException {
        URI uri = new URI(Utils.trim((String)url));
        HttpGet httpRequest = new HttpGet(uri);
        if (this.contentType != null) {
            httpRequest.setHeader(CONTENT_TYPE, (Object)this.contentType);
        }
        return httpRequest;
    }

    protected synchronized HttpClientBuilder getHttpClientBuilder(String url) {
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        if (this.useSystemProperties) {
            httpClientBuilder.useSystemProperties();
        }
        httpClientBuilder = this.configCredentials(httpClientBuilder, url);
        httpClientBuilder.setConnectionManager(this.getConnectionManager()).setDefaultRequestConfig(this.getRequestConfig()).setRetryStrategy(this.retryStrategy);
        return httpClientBuilder;
    }

    protected synchronized CloseableHttpClient getHttpClient(String url) {
        return this.getHttpClientBuilder(url).build();
    }

    protected RequestConfig.Builder getRequestConfigBuilder() {
        return RequestConfig.custom().setTargetPreferredAuthSchemes(this.targetPreferredAuthSchemes).setConnectionRequestTimeout(this.timeoutConnectionRequest).setResponseTimeout(this.timeoutResponse).setConnectionKeepAlive(this.connectionKeepAlive).setRedirectsEnabled(this.redirectsEnabled);
    }

    protected RequestConfig getRequestConfig() {
        return this.getRequestConfigBuilder().build();
    }

    private HttpClientBuilder configCredentials(HttpClientBuilder httpClientBuilder, String url) {
        BasicCredentialsProvider credentialsProvider = this.getCredentialsProvider();
        httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        httpClientBuilder = this.configureProxy(httpClientBuilder, credentialsProvider, url);
        return httpClientBuilder;
    }

    protected BasicCredentialsProvider getCredentialsProvider() {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        for (Map.Entry<HostConnection, UserCredentials> entry : this.getAuthenticationMap().entrySet()) {
            HostConnection hostConnection = entry.getKey();
            UserCredentials userCredentials = entry.getValue();
            AuthScope authscope = new AuthScope(hostConnection.getProtocol(), hostConnection.getHost(), hostConnection.getPort(), hostConnection.getRealm(), hostConnection.getScheme());
            UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(userCredentials.getUsername(), userCredentials.getPassword());
            credentialsProvider.setCredentials(authscope, (Credentials)usernamePasswordCredentials);
        }
        return credentialsProvider;
    }

    private HttpClientBuilder configureProxy(HttpClientBuilder httpClientBuilder, BasicCredentialsProvider credentialsProvider, String url) {
        ProxyProperties proxyProps;
        boolean proxyHTTP;
        if (this.proxyConfig == null) {
            return httpClientBuilder;
        }
        String protocol = this.getURL(url).getProtocol();
        boolean proxyHTTPS = Protocol.isHttps((String)protocol) && this.proxyConfig.getHttpsProperties() != null;
        boolean bl = proxyHTTP = Protocol.isHttp((String)protocol) && this.proxyConfig.getHttpProperties() != null;
        if (proxyHTTPS) {
            LOG.debug("Use proxy https parameters");
            proxyProps = this.proxyConfig.getHttpsProperties();
        } else if (proxyHTTP) {
            LOG.debug("Use proxy http parameters");
            proxyProps = this.proxyConfig.getHttpProperties();
        } else {
            return httpClientBuilder;
        }
        String scheme = proxyProps.getScheme();
        String proxyHost = proxyProps.getHost();
        int proxyPort = proxyProps.getPort();
        String proxyUser = proxyProps.getUser();
        char[] proxyPassword = proxyProps.getPassword();
        final Collection<String> excludedHosts = proxyProps.getExcludedHosts();
        if (Utils.isStringNotEmpty((String)proxyUser) && Utils.isArrayNotEmpty((char[])proxyPassword)) {
            AuthScope proxyAuth = new AuthScope(proxyHost, proxyPort);
            UsernamePasswordCredentials proxyCredentials = new UsernamePasswordCredentials(proxyUser, proxyPassword);
            credentialsProvider.setCredentials(proxyAuth, (Credentials)proxyCredentials);
        }
        LOG.debug("proxy host/port: {}:{}", (Object)proxyHost, (Object)proxyPort);
        HttpHost proxy = new HttpHost(scheme, proxyHost, proxyPort);
        if (Utils.isCollectionNotEmpty(excludedHosts)) {
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy){

                protected HttpHost determineProxy(HttpHost host, HttpContext context) throws HttpException {
                    String hostname;
                    String string = hostname = host != null ? host.getHostName().toLowerCase() : null;
                    if (hostname != null) {
                        for (String h : excludedHosts) {
                            String matchingEnd;
                            String hostnamePattern = h.toLowerCase();
                            if (hostname.equals(hostnamePattern)) {
                                return null;
                            }
                            if (hostnamePattern.equals("*")) {
                                return null;
                            }
                            if (!hostnamePattern.startsWith("*.") || !hostname.endsWith(matchingEnd = hostnamePattern.substring(1).toLowerCase())) continue;
                            return null;
                        }
                    }
                    return super.determineProxy(host, context);
                }
            };
            httpClientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
        }
        return httpClientBuilder.setProxy(proxy);
    }

    private static Timeout toTimeoutMilliseconds(int millis) {
        if (millis < 0) {
            LOG.info("A negative timeout has been provided. Use system default.");
            return null;
        }
        return Timeout.ofMilliseconds((long)millis);
    }

    private static TimeValue toTimeValueMilliseconds(int millis) {
        return TimeValue.ofMilliseconds((long)millis);
    }

    private static ContentType toContentType(String contentTypeString) {
        return Utils.isStringNotBlank((String)contentTypeString) ? ContentType.create((String)contentTypeString) : null;
    }
}

