/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.policy;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.Level;
import eu.europa.esig.dss.model.policy.CryptographicSuite;
import eu.europa.esig.dss.model.policy.EncryptionAlgorithmWithMinKeySize;
import eu.europa.esig.dss.policy.LevelConstraintWrapper;
import eu.europa.esig.dss.policy.jaxb.Algo;
import eu.europa.esig.dss.policy.jaxb.AlgoExpirationDate;
import eu.europa.esig.dss.policy.jaxb.CryptographicConstraint;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.policy.jaxb.ListAlgo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptographicConstraintWrapper
extends LevelConstraintWrapper
implements CryptographicSuite {
    private static final Logger LOG = LoggerFactory.getLogger(CryptographicConstraintWrapper.class);
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private List<DigestAlgorithm> acceptableDigestAlgorithms;
    private List<EncryptionAlgorithm> acceptableEncryptionAlgorithms;
    private List<EncryptionAlgorithmWithMinKeySize> acceptableEncryptionAlgorithmsWithMinKeySizes;
    private Map<DigestAlgorithm, Date> acceptableDigestAlgorithmsWithExpirationDates;
    private Map<EncryptionAlgorithmWithMinKeySize, Date> acceptableEncryptionAlgorithmsWithExpirationDates;

    public CryptographicConstraintWrapper() {
        super(null);
    }

    public CryptographicConstraintWrapper(CryptographicConstraint constraint) {
        super(constraint);
    }

    public String getPolicyName() {
        return "DSS Cryptographic Constraint";
    }

    public List<DigestAlgorithm> getAcceptableDigestAlgorithms() {
        if (this.acceptableDigestAlgorithms == null) {
            ListAlgo acceptableDigestAlgos;
            this.acceptableDigestAlgorithms = new ArrayList<DigestAlgorithm>();
            if (this.constraint != null && (acceptableDigestAlgos = ((CryptographicConstraint)this.constraint).getAcceptableDigestAlgo()) != null) {
                for (Algo algo : acceptableDigestAlgos.getAlgos()) {
                    DigestAlgorithm digestAlgorithm = this.toDigestAlgorithm(algo.getValue());
                    if (digestAlgorithm == null) continue;
                    this.acceptableDigestAlgorithms.add(digestAlgorithm);
                }
            }
        }
        return this.acceptableDigestAlgorithms;
    }

    public List<EncryptionAlgorithm> getAcceptableEncryptionAlgorithms() {
        if (this.acceptableEncryptionAlgorithms == null) {
            ListAlgo acceptableEncryptionAlgos;
            this.acceptableEncryptionAlgorithms = new ArrayList<EncryptionAlgorithm>();
            if (this.constraint != null && (acceptableEncryptionAlgos = ((CryptographicConstraint)this.constraint).getAcceptableEncryptionAlgo()) != null) {
                for (Algo algo : acceptableEncryptionAlgos.getAlgos()) {
                    EncryptionAlgorithm encryptionAlgorithm = this.toEncryptionAlgorithm(algo.getValue());
                    if (encryptionAlgorithm == null) continue;
                    this.acceptableEncryptionAlgorithms.add(encryptionAlgorithm);
                }
            }
        }
        return this.acceptableEncryptionAlgorithms;
    }

    public List<EncryptionAlgorithmWithMinKeySize> getAcceptableEncryptionAlgorithmsWithMinKeySizes() {
        if (this.acceptableEncryptionAlgorithmsWithMinKeySizes == null) {
            ListAlgo miniPublicKeySizes;
            this.acceptableEncryptionAlgorithmsWithMinKeySizes = new ArrayList<EncryptionAlgorithmWithMinKeySize>();
            if (this.constraint != null && (miniPublicKeySizes = ((CryptographicConstraint)this.constraint).getMiniPublicKeySize()) != null) {
                for (Algo algo : miniPublicKeySizes.getAlgos()) {
                    EncryptionAlgorithm encryptionAlgorithm = this.toEncryptionAlgorithm(algo.getValue());
                    if (encryptionAlgorithm == null) continue;
                    this.acceptableEncryptionAlgorithmsWithMinKeySizes.add(new EncryptionAlgorithmWithMinKeySize(encryptionAlgorithm, algo.getSize().intValue()));
                }
            }
        }
        return this.acceptableEncryptionAlgorithmsWithMinKeySizes;
    }

    public Map<DigestAlgorithm, Date> getAcceptableDigestAlgorithmsWithExpirationDates() {
        if (this.acceptableDigestAlgorithmsWithExpirationDates == null) {
            AlgoExpirationDate algoExpirationDates;
            this.acceptableDigestAlgorithmsWithExpirationDates = new LinkedHashMap<DigestAlgorithm, Date>();
            if (this.constraint != null && (algoExpirationDates = ((CryptographicConstraint)this.constraint).getAlgoExpirationDate()) != null) {
                SimpleDateFormat dateFormat = this.getUsedDateFormat(algoExpirationDates);
                for (Algo algo : algoExpirationDates.getAlgos()) {
                    DigestAlgorithm digestAlgorithm = this.toDigestAlgorithm(algo.getValue());
                    if (digestAlgorithm == null) continue;
                    Date expirationDate = this.getDate(algo, dateFormat);
                    this.acceptableDigestAlgorithmsWithExpirationDates.put(digestAlgorithm, expirationDate);
                }
            }
        }
        return this.acceptableDigestAlgorithmsWithExpirationDates;
    }

    private DigestAlgorithm toDigestAlgorithm(String algorithmName) {
        try {
            return DigestAlgorithm.forName((String)algorithmName);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private SimpleDateFormat getUsedDateFormat(AlgoExpirationDate expirations) {
        SimpleDateFormat sdf = new SimpleDateFormat(expirations.getFormat() != null ? expirations.getFormat() : DEFAULT_DATE_FORMAT);
        sdf.setTimeZone(UTC);
        return sdf;
    }

    private Date getDate(Algo algo, SimpleDateFormat format) {
        if (algo != null) {
            return this.getDate(algo.getDate(), format);
        }
        return null;
    }

    private Date getDate(String dateString, SimpleDateFormat format) {
        if (dateString != null) {
            try {
                return format.parse(dateString);
            }
            catch (ParseException e) {
                LOG.warn("Unable to parse '{}' with format '{}'", (Object)dateString, (Object)format);
            }
        }
        return null;
    }

    public Map<EncryptionAlgorithmWithMinKeySize, Date> getAcceptableEncryptionAlgorithmsWithExpirationDates() {
        if (this.acceptableEncryptionAlgorithmsWithExpirationDates == null) {
            AlgoExpirationDate algoExpirationDates;
            this.acceptableEncryptionAlgorithmsWithExpirationDates = new LinkedHashMap<EncryptionAlgorithmWithMinKeySize, Date>();
            if (this.constraint != null && (algoExpirationDates = ((CryptographicConstraint)this.constraint).getAlgoExpirationDate()) != null) {
                SimpleDateFormat dateFormat = this.getUsedDateFormat(algoExpirationDates);
                for (Algo algo : algoExpirationDates.getAlgos()) {
                    EncryptionAlgorithm encryptionAlgorithm = this.toEncryptionAlgorithm(algo.getValue());
                    if (encryptionAlgorithm == null) continue;
                    Date expirationDate = this.getDate(algo, dateFormat);
                    this.acceptableEncryptionAlgorithmsWithExpirationDates.put(new EncryptionAlgorithmWithMinKeySize(encryptionAlgorithm, algo.getSize().intValue()), expirationDate);
                }
            }
        }
        return this.acceptableEncryptionAlgorithmsWithExpirationDates;
    }

    private EncryptionAlgorithm toEncryptionAlgorithm(String algorithmName) {
        try {
            return EncryptionAlgorithm.forName((String)algorithmName);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public void setLevel(Level level) {
        if (this.constraint != null) {
            this.constraint.setLevel(level);
        }
    }

    public Level getAcceptableEncryptionAlgorithmsLevel() {
        if (this.constraint != null) {
            return this.getCryptographicLevel(((CryptographicConstraint)this.constraint).getAcceptableEncryptionAlgo());
        }
        return null;
    }

    public void setAcceptableEncryptionAlgorithmsLevel(Level acceptableEncryptionAlgorithmsLevel) {
        ListAlgo acceptableEncryptionAlgo;
        if (this.constraint != null && (acceptableEncryptionAlgo = ((CryptographicConstraint)this.constraint).getAcceptableEncryptionAlgo()) != null) {
            acceptableEncryptionAlgo.setLevel(acceptableEncryptionAlgorithmsLevel);
        }
    }

    public Level getAcceptableEncryptionAlgorithmsMiniKeySizeLevel() {
        if (this.constraint != null) {
            return this.getCryptographicLevel(((CryptographicConstraint)this.constraint).getMiniPublicKeySize());
        }
        return null;
    }

    public void setAcceptableEncryptionAlgorithmsMiniKeySizeLevel(Level acceptableEncryptionAlgorithmsMiniKeySizeLevel) {
        ListAlgo miniPublicKeySize;
        if (this.constraint != null && (miniPublicKeySize = ((CryptographicConstraint)this.constraint).getMiniPublicKeySize()) != null) {
            miniPublicKeySize.setLevel(acceptableEncryptionAlgorithmsMiniKeySizeLevel);
        }
    }

    public Level getAcceptableDigestAlgorithmsLevel() {
        if (this.constraint != null) {
            return this.getCryptographicLevel(((CryptographicConstraint)this.constraint).getAcceptableDigestAlgo());
        }
        return null;
    }

    public void setAcceptableDigestAlgorithmsLevel(Level acceptableDigestAlgorithmsLevel) {
        ListAlgo acceptableDigestAlgo;
        if (this.constraint != null && (acceptableDigestAlgo = ((CryptographicConstraint)this.constraint).getAcceptableDigestAlgo()) != null) {
            acceptableDigestAlgo.setLevel(acceptableDigestAlgorithmsLevel);
        }
    }

    public Level getAlgorithmsExpirationDateLevel() {
        if (this.constraint != null) {
            return this.getCryptographicLevel(((CryptographicConstraint)this.constraint).getAlgoExpirationDate());
        }
        return null;
    }

    public void setAlgorithmsExpirationDateLevel(Level algorithmsExpirationDateLevel) {
        AlgoExpirationDate algoExpirationDate;
        if (this.constraint != null && (algoExpirationDate = ((CryptographicConstraint)this.constraint).getAlgoExpirationDate()) != null) {
            algoExpirationDate.setLevel(algorithmsExpirationDateLevel);
        }
    }

    public Level getAlgorithmsExpirationDateAfterUpdateLevel() {
        if (this.constraint != null) {
            AlgoExpirationDate algoExpirationDate = ((CryptographicConstraint)this.constraint).getAlgoExpirationDate();
            if (algoExpirationDate != null && algoExpirationDate.getLevelAfterUpdate() != null) {
                return algoExpirationDate.getLevelAfterUpdate();
            }
            return this.getCryptographicLevel(algoExpirationDate);
        }
        return null;
    }

    public void setAlgorithmsExpirationTimeAfterPolicyUpdateLevel(Level algorithmsExpirationTimeAfterPolicyUpdateLevel) {
        AlgoExpirationDate algoExpirationDate;
        if (this.constraint != null && (algoExpirationDate = ((CryptographicConstraint)this.constraint).getAlgoExpirationDate()) != null) {
            algoExpirationDate.setLevelAfterUpdate(algorithmsExpirationTimeAfterPolicyUpdateLevel);
        }
    }

    public Date getCryptographicSuiteUpdateDate() {
        AlgoExpirationDate algoExpirationDates;
        if (this.constraint != null && (algoExpirationDates = ((CryptographicConstraint)this.constraint).getAlgoExpirationDate()) != null) {
            SimpleDateFormat dateFormat = this.getUsedDateFormat(algoExpirationDates);
            return this.getDate(algoExpirationDates.getUpdateDate(), dateFormat);
        }
        return null;
    }

    private Level getCryptographicLevel(LevelConstraint cryptoConstraint) {
        if (cryptoConstraint != null && cryptoConstraint.getLevel() != null) {
            return cryptoConstraint.getLevel();
        }
        return this.getLevel();
    }
}

