/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model.tsl;

import eu.europa.esig.dss.model.identifier.Identifier;
import eu.europa.esig.dss.model.tsl.CertificatePivotStatus;
import eu.europa.esig.dss.model.tsl.DownloadInfoRecord;
import eu.europa.esig.dss.model.tsl.LOTLInfo;
import eu.europa.esig.dss.model.tsl.ParsingInfoRecord;
import eu.europa.esig.dss.model.tsl.ValidationInfoRecord;
import eu.europa.esig.dss.model.tsl.identifier.PivotIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import java.util.Map;

public class PivotInfo
extends LOTLInfo {
    private static final long serialVersionUID = 1724138551018429654L;
    private Map<CertificateToken, CertificatePivotStatus> certificateStatusMap;
    private String lotlLocation;

    public PivotInfo(DownloadInfoRecord downloadCacheInfo, ParsingInfoRecord parsingCacheInfo, ValidationInfoRecord validationCacheInfo, String url, Map<CertificateToken, CertificatePivotStatus> certificates, String lotlLocation) {
        super(downloadCacheInfo, parsingCacheInfo, validationCacheInfo, url);
        this.certificateStatusMap = certificates;
        this.lotlLocation = lotlLocation;
    }

    public Map<CertificateToken, CertificatePivotStatus> getCertificateStatusMap() {
        return this.certificateStatusMap;
    }

    public String getLOTLLocation() {
        return this.lotlLocation;
    }

    @Override
    public boolean isPivot() {
        return true;
    }

    @Override
    protected Identifier buildIdentifier() {
        return new PivotIdentifier(this);
    }
}

