/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model.policy;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.Level;
import eu.europa.esig.dss.model.policy.CryptographicSuite;
import eu.europa.esig.dss.model.policy.EncryptionAlgorithmWithMinKeySize;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class Abstract19322CryptographicSuite
implements CryptographicSuite {
    protected static final String MODULES_LENGTH_PARAMETER = "moduluslength";
    protected static final String PLENGTH_PARAMETER = "plength";
    protected static final String QLENGTH_PARAMETER = "qlength";
    private Level globalLevel = Level.FAIL;
    private Level acceptableEncryptionAlgorithmsLevel;
    private Level acceptableEncryptionAlgorithmsMinKeySizeLevel;
    private Level acceptableDigestAlgorithmsLevel;
    private Level algorithmsExpirationDateLevel;
    private Level algorithmsExpirationTimeAfterPolicyUpdateLevel = Level.WARN;
    private List<DigestAlgorithm> acceptableDigestAlgorithms;
    private List<EncryptionAlgorithm> acceptableEncryptionAlgorithms;
    private List<EncryptionAlgorithmWithMinKeySize> acceptableEncryptionAlgorithmsWithMinKeySizes;
    private Map<DigestAlgorithm, Date> acceptableDigestAlgorithmsWithExpirationDates;
    private Map<EncryptionAlgorithmWithMinKeySize, Date> acceptableEncryptionAlgorithmsWithExpirationDates;

    protected Abstract19322CryptographicSuite() {
    }

    @Override
    public Level getLevel() {
        return this.globalLevel;
    }

    @Override
    public void setLevel(Level level) {
        this.globalLevel = level;
    }

    @Override
    public Level getAcceptableDigestAlgorithmsLevel() {
        return this.getLevel(this.acceptableDigestAlgorithmsLevel);
    }

    @Override
    public void setAcceptableDigestAlgorithmsLevel(Level acceptableDigestAlgorithmsLevel) {
        this.acceptableDigestAlgorithmsLevel = acceptableDigestAlgorithmsLevel;
    }

    @Override
    public Level getAcceptableEncryptionAlgorithmsLevel() {
        return this.getLevel(this.acceptableEncryptionAlgorithmsLevel);
    }

    @Override
    public void setAcceptableEncryptionAlgorithmsLevel(Level acceptableEncryptionAlgorithmsLevel) {
        this.acceptableEncryptionAlgorithmsLevel = acceptableEncryptionAlgorithmsLevel;
    }

    @Override
    public Level getAcceptableEncryptionAlgorithmsMiniKeySizeLevel() {
        return this.getLevel(this.acceptableEncryptionAlgorithmsMinKeySizeLevel);
    }

    @Override
    public void setAcceptableEncryptionAlgorithmsMiniKeySizeLevel(Level acceptableEncryptionAlgorithmsMiniKeySizeLevel) {
        this.acceptableEncryptionAlgorithmsMinKeySizeLevel = acceptableEncryptionAlgorithmsMiniKeySizeLevel;
    }

    @Override
    public Level getAlgorithmsExpirationDateLevel() {
        return this.getLevel(this.algorithmsExpirationDateLevel);
    }

    @Override
    public void setAlgorithmsExpirationDateLevel(Level algorithmsExpirationDateLevel) {
        this.algorithmsExpirationDateLevel = algorithmsExpirationDateLevel;
    }

    @Override
    public Level getAlgorithmsExpirationDateAfterUpdateLevel() {
        return this.algorithmsExpirationTimeAfterPolicyUpdateLevel;
    }

    @Override
    public void setAlgorithmsExpirationTimeAfterPolicyUpdateLevel(Level algorithmsExpirationTimeAfterPolicyUpdateLevel) {
        this.algorithmsExpirationTimeAfterPolicyUpdateLevel = algorithmsExpirationTimeAfterPolicyUpdateLevel;
    }

    private Level getLevel(Level level) {
        return level != null ? level : this.globalLevel;
    }

    @Override
    public List<DigestAlgorithm> getAcceptableDigestAlgorithms() {
        if (this.acceptableDigestAlgorithms == null) {
            this.acceptableDigestAlgorithms = new ArrayList<DigestAlgorithm>(this.getAcceptableDigestAlgorithmsWithExpirationDates().keySet());
        }
        return this.acceptableDigestAlgorithms;
    }

    @Override
    public List<EncryptionAlgorithm> getAcceptableEncryptionAlgorithms() {
        if (this.acceptableEncryptionAlgorithms == null) {
            this.acceptableEncryptionAlgorithms = this.getAcceptableEncryptionAlgorithmsWithMinKeySizes().stream().map(EncryptionAlgorithmWithMinKeySize::getEncryptionAlgorithm).collect(Collectors.toList());
        }
        return this.acceptableEncryptionAlgorithms;
    }

    @Override
    public List<EncryptionAlgorithmWithMinKeySize> getAcceptableEncryptionAlgorithmsWithMinKeySizes() {
        if (this.acceptableEncryptionAlgorithmsWithMinKeySizes == null) {
            EnumMap<EncryptionAlgorithm, Integer> encryptionAlgorithmWithMinKeySizesMap = new EnumMap<EncryptionAlgorithm, Integer>(EncryptionAlgorithm.class);
            for (EncryptionAlgorithmWithMinKeySize encryptionAlgorithmWithMinKeySize : this.getAcceptableEncryptionAlgorithmsWithExpirationDates().keySet()) {
                EncryptionAlgorithm encryptionAlgorithm = encryptionAlgorithmWithMinKeySize.getEncryptionAlgorithm();
                int keySize = encryptionAlgorithmWithMinKeySize.getMinKeySize();
                Integer minKeySize = (Integer)encryptionAlgorithmWithMinKeySizesMap.get(encryptionAlgorithm);
                if (minKeySize == null || minKeySize > keySize) {
                    minKeySize = keySize;
                }
                encryptionAlgorithmWithMinKeySizesMap.put(encryptionAlgorithm, minKeySize);
            }
            this.acceptableEncryptionAlgorithmsWithMinKeySizes = encryptionAlgorithmWithMinKeySizesMap.entrySet().stream().map(e -> new EncryptionAlgorithmWithMinKeySize((EncryptionAlgorithm)e.getKey(), (Integer)e.getValue())).collect(Collectors.toList());
        }
        return this.acceptableEncryptionAlgorithmsWithMinKeySizes;
    }

    @Override
    public Map<DigestAlgorithm, Date> getAcceptableDigestAlgorithmsWithExpirationDates() {
        if (this.acceptableDigestAlgorithmsWithExpirationDates == null) {
            this.acceptableDigestAlgorithmsWithExpirationDates = this.buildAcceptableDigestAlgorithmsWithExpirationDates();
        }
        return this.acceptableDigestAlgorithmsWithExpirationDates;
    }

    @Override
    public Map<EncryptionAlgorithmWithMinKeySize, Date> getAcceptableEncryptionAlgorithmsWithExpirationDates() {
        if (this.acceptableEncryptionAlgorithmsWithExpirationDates == null) {
            this.acceptableEncryptionAlgorithmsWithExpirationDates = this.buildAcceptableEncryptionAlgorithmsWithExpirationDates();
        }
        return this.acceptableEncryptionAlgorithmsWithExpirationDates;
    }

    protected abstract Map<DigestAlgorithm, Date> buildAcceptableDigestAlgorithmsWithExpirationDates();

    protected abstract Map<EncryptionAlgorithmWithMinKeySize, Date> buildAcceptableEncryptionAlgorithmsWithExpirationDates();
}

