/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.ws.converter;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.ws.dto.RemoteDocument;
import eu.europa.esig.dss.ws.dto.exception.DSSRemoteServiceException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RemoteDocumentConverter {
    private RemoteDocumentConverter() {
    }

    public static List<DSSDocument> toDSSDocuments(List<RemoteDocument> remoteDocuments) {
        if (Utils.isCollectionNotEmpty(remoteDocuments)) {
            ArrayList<DSSDocument> dssDocuments = new ArrayList<DSSDocument>();
            for (RemoteDocument remoteDocument : remoteDocuments) {
                DSSDocument dssDocument = RemoteDocumentConverter.toDSSDocument(remoteDocument);
                if (dssDocument == null) continue;
                dssDocuments.add(dssDocument);
            }
            return dssDocuments;
        }
        return Collections.emptyList();
    }

    public static DSSDocument toDSSDocument(RemoteDocument remoteDocument) {
        if (remoteDocument == null || Utils.isArrayEmpty((byte[])remoteDocument.getBytes())) {
            return null;
        }
        if (remoteDocument.getDigestAlgorithm() != null) {
            return new DigestDocument(remoteDocument.getDigestAlgorithm(), Utils.toBase64((byte[])remoteDocument.getBytes()), remoteDocument.getName());
        }
        return new InMemoryDocument(remoteDocument.getBytes(), remoteDocument.getName());
    }

    public static List<RemoteDocument> toRemoteDocuments(List<DSSDocument> originalDocuments) {
        ArrayList<RemoteDocument> results = new ArrayList<RemoteDocument>();
        for (DSSDocument originalDocument : originalDocuments) {
            RemoteDocument remoteDocument = RemoteDocumentConverter.toRemoteDocument(originalDocument);
            if (remoteDocument == null) continue;
            results.add(remoteDocument);
        }
        return results;
    }

    public static RemoteDocument toRemoteDocument(DSSDocument originalDocument) {
        if (originalDocument == null) {
            return null;
        }
        if (originalDocument instanceof DigestDocument) {
            DigestDocument digestDocument = (DigestDocument)originalDocument;
            Digest digest = digestDocument.getExistingDigest();
            if (digest.getAlgorithm() == null || digest.getValue() == null) {
                throw new DSSRemoteServiceException("Impossible to create a RemoteDocument from a DigestDocument with not defined Digest");
            }
            return new RemoteDocument(digest.getValue(), digest.getAlgorithm(), originalDocument.getName());
        }
        return new RemoteDocument(DSSUtils.toByteArray((DSSDocument)originalDocument), originalDocument.getName());
    }
}

