/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation.scope;

import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.ManifestEntry;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.model.ReferenceValidation;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.scope.AbstractSignatureScopeFinder;
import eu.europa.esig.dss.spi.validation.scope.ContainerContentSignatureScope;
import eu.europa.esig.dss.spi.validation.scope.ContainerSignatureScope;
import eu.europa.esig.dss.spi.validation.scope.CounterSignatureScope;
import eu.europa.esig.dss.spi.validation.scope.DigestSignatureScope;
import eu.europa.esig.dss.spi.validation.scope.FullSignatureScope;
import eu.europa.esig.dss.spi.validation.scope.ManifestSignatureScope;
import eu.europa.esig.dss.spi.validation.scope.SignatureScopeFinder;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESSignatureScopeFinder
extends AbstractSignatureScopeFinder
implements SignatureScopeFinder<CAdESSignature> {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESSignatureScopeFinder.class);

    public List<SignatureScope> findSignatureScope(CAdESSignature cadesSignature) {
        DSSDocument originalDocument = this.getOriginalDocument(cadesSignature);
        if (originalDocument == null) {
            return Collections.emptyList();
        }
        ArrayList<SignatureScope> result = new ArrayList<SignatureScope>();
        if (this.isASiCSArchive((AdvancedSignature)cadesSignature)) {
            ContainerSignatureScope containerSignatureScope = new ContainerSignatureScope(originalDocument);
            result.add((SignatureScope)containerSignatureScope);
            for (DSSDocument archivedDocument : cadesSignature.getContainerContents()) {
                containerSignatureScope.addChildSignatureScope((SignatureScope)new ContainerContentSignatureScope(archivedDocument));
            }
        } else if (this.isASiCEArchive((AdvancedSignature)cadesSignature)) {
            ManifestFile manifestFile = cadesSignature.getManifestFile();
            ManifestSignatureScope manifestSignatureScope = new ManifestSignatureScope(manifestFile);
            result.add((SignatureScope)manifestSignatureScope);
            for (ManifestEntry manifestEntry : manifestFile.getEntries()) {
                if (!manifestEntry.isIntact()) continue;
                DSSDocument referencedDocument = this.getReferencedDocument(manifestEntry, cadesSignature.getContainerContents());
                manifestSignatureScope.addChildSignatureScope((SignatureScope)new FullSignatureScope(manifestEntry.getUri(), referencedDocument));
            }
        } else {
            List<ReferenceValidation> referenceValidations = cadesSignature.getReferenceValidations();
            if (Utils.isCollectionNotEmpty(referenceValidations)) {
                ReferenceValidation reference = referenceValidations.iterator().next();
                if (reference.isIntact()) {
                    return this.getSignatureScopeFromOriginalDocument(cadesSignature, originalDocument);
                }
                if (reference.isFound()) {
                    return this.getSignatureScopeFromReferenceValidation(reference);
                }
            }
        }
        return result;
    }

    protected List<SignatureScope> getSignatureScopeFromOriginalDocument(CAdESSignature cadesSignature, DSSDocument originalDocument) {
        ArrayList<SignatureScope> result = new ArrayList<SignatureScope>();
        if (originalDocument == null) {
            return result;
        }
        String fileName = originalDocument.getName();
        if (cadesSignature.isCounterSignature()) {
            return Collections.singletonList(new CounterSignatureScope(cadesSignature.getMasterSignature(), originalDocument));
        }
        if (originalDocument instanceof DigestDocument) {
            DigestDocument digestDocument = (DigestDocument)originalDocument;
            result.add((SignatureScope)new DigestSignatureScope(fileName != null ? fileName : "Digest document", (DSSDocument)digestDocument));
        } else {
            result.add((SignatureScope)new FullSignatureScope(fileName != null ? fileName : "Full document", originalDocument));
        }
        return result;
    }

    protected List<SignatureScope> getSignatureScopeFromReferenceValidation(ReferenceValidation reference) {
        ArrayList<SignatureScope> result = new ArrayList<SignatureScope>();
        DSSDocument digestDocument = this.createDigestDocument(reference.getDigest());
        if (digestDocument != null) {
            result.add((SignatureScope)new FullSignatureScope("Full document", digestDocument));
        }
        return result;
    }

    protected DSSDocument getOriginalDocument(CAdESSignature cadesSignature) {
        try {
            return cadesSignature.getOriginalDocument();
        }
        catch (DSSException e) {
            LOG.warn("A CAdES signer's original document is not found [{}].", (Object)e.getMessage());
            return null;
        }
    }

    protected boolean isASiCSArchive(AdvancedSignature advancedSignature) {
        return super.isASiCSArchive(advancedSignature) && !super.isASiCEArchive(advancedSignature);
    }

    protected DSSDocument getReferencedDocument(ManifestEntry manifestEntry, List<DSSDocument> detachedDocuments) {
        DSSDocument document = DSSUtils.getDocumentWithName(detachedDocuments, (String)manifestEntry.getUri());
        if (document == null) {
            document = this.createDigestDocument(manifestEntry.getDigest());
        }
        return document;
    }
}

