/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.CAdESUtils;
import eu.europa.esig.dss.cades.evidencerecord.CAdESEmbeddedEvidenceRecordBuilder;
import eu.europa.esig.dss.cades.evidencerecord.CAdESEvidenceRecordIncorporationParameters;
import eu.europa.esig.dss.cades.signature.CAdESCounterSignatureBuilder;
import eu.europa.esig.dss.cades.signature.CAdESCounterSignatureParameters;
import eu.europa.esig.dss.cades.signature.CAdESLevelBaselineLT;
import eu.europa.esig.dss.cades.signature.CAdESLevelBaselineLTA;
import eu.europa.esig.dss.cades.signature.CAdESLevelBaselineT;
import eu.europa.esig.dss.cades.signature.CAdESSignatureExtension;
import eu.europa.esig.dss.cades.signature.CAdESSignaturePolicyStoreBuilder;
import eu.europa.esig.dss.cades.signature.CAdESTimestampParameters;
import eu.europa.esig.dss.cades.signature.CMSBuilder;
import eu.europa.esig.dss.cades.signature.CMSSignerInfoGeneratorBuilder;
import eu.europa.esig.dss.cades.signature.CustomContentSigner;
import eu.europa.esig.dss.cms.CMS;
import eu.europa.esig.dss.cms.CMSUtils;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.enumerations.SigningOperation;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.evidencerecord.EvidenceRecordIncorporationService;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.SignaturePolicyStore;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.TimestampBinary;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.signature.AbstractSignatureService;
import eu.europa.esig.dss.signature.CounterSignatureService;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.signature.resources.DSSResourcesHandlerBuilder;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.tsp.TSPException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESService
extends AbstractSignatureService<CAdESSignatureParameters, CAdESTimestampParameters>
implements CounterSignatureService<CAdESCounterSignatureParameters>,
EvidenceRecordIncorporationService<CAdESEvidenceRecordIncorporationParameters> {
    private static final long serialVersionUID = -7744554779153433450L;
    private static final Logger LOG = LoggerFactory.getLogger(CAdESService.class);
    protected DSSResourcesHandlerBuilder resourcesHandlerBuilder = CAdESUtils.DEFAULT_RESOURCES_HANDLER_BUILDER;

    public CAdESService(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
        LOG.debug("+ CAdESService created");
    }

    public void setResourcesHandlerBuilder(DSSResourcesHandlerBuilder resourcesHandlerBuilder) {
        this.resourcesHandlerBuilder = CMSUtils.getDSSResourcesHandlerBuilder((DSSResourcesHandlerBuilder)resourcesHandlerBuilder);
    }

    public TimestampToken getContentTimestamp(DSSDocument toSignDocument, CAdESSignatureParameters parameters) {
        Objects.requireNonNull(this.tspSource, "A TSPSource is required !");
        DigestAlgorithm digestAlgorithm = parameters.getContentTimestampParameters().getDigestAlgorithm();
        TimestampBinary timeStampResponse = this.tspSource.getTimeStampResponse(digestAlgorithm, toSignDocument.getDigestValue(digestAlgorithm));
        try {
            return new TimestampToken(timeStampResponse.getBytes(), TimestampType.CONTENT_TIMESTAMP);
        }
        catch (IOException | CMSException | TSPException e) {
            throw new DSSException("Cannot create a content TimestampToken", e);
        }
    }

    public ToBeSigned getDataToSign(DSSDocument toSignDocument, CAdESSignatureParameters parameters) {
        Objects.requireNonNull(toSignDocument, "toSignDocument cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        this.assertSigningCertificateValid(parameters);
        SignaturePackaging packaging = parameters.getSignaturePackaging();
        this.assertSignaturePackaging(packaging);
        SignatureAlgorithm signatureAlgorithm = parameters.getSignatureAlgorithm();
        CustomContentSigner customContentSigner = new CustomContentSigner(signatureAlgorithm.getJCEId());
        CMS originalCms = this.getOriginalCMS(toSignDocument, parameters);
        DSSDocument contentToSign = this.getContentToSign(toSignDocument, parameters, originalCms);
        SignerInfoGenerator signerInfoGenerator = new CMSSignerInfoGeneratorBuilder().build(contentToSign, parameters, customContentSigner);
        CMSBuilder cmsBuilder = this.getCMSBuilder(parameters).setOriginalCMS(originalCms);
        CMS cms = cmsBuilder.createCMS(signerInfoGenerator, contentToSign);
        CMSUtils.writeToDSSDocument((CMS)cms, (DSSResourcesHandlerBuilder)this.resourcesHandlerBuilder);
        byte[] bytes = customContentSigner.getOutputStream().toByteArray();
        return new ToBeSigned(bytes);
    }

    public DSSDocument signDocument(DSSDocument toSignDocument, CAdESSignatureParameters parameters, SignatureValue signatureValue) {
        Objects.requireNonNull(toSignDocument, "toSignDocument cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        Objects.requireNonNull(signatureValue, "SignatureValue cannot be null!");
        this.assertSigningCertificateValid(parameters);
        SignaturePackaging packaging = parameters.getSignaturePackaging();
        this.assertSignaturePackaging(packaging);
        SignatureAlgorithm signatureAlgorithm = parameters.getSignatureAlgorithm();
        signatureValue = this.ensureSignatureValue(signatureAlgorithm, signatureValue);
        CustomContentSigner customContentSigner = new CustomContentSigner(signatureAlgorithm.getJCEId(), signatureValue.getValue());
        CMS originalCms = this.getOriginalCMS(toSignDocument, parameters);
        if (originalCms == null && SignaturePackaging.DETACHED.equals((Object)packaging) && Utils.isCollectionEmpty((Collection)parameters.getDetachedContents())) {
            parameters.getContext().setDetachedContents(Collections.singletonList(toSignDocument));
        }
        DSSDocument contentToSign = this.getContentToSign(toSignDocument, parameters, originalCms);
        SignerInfoGenerator signerInfoGenerator = new CMSSignerInfoGeneratorBuilder().setIncludeUnsignedAttributes(true).build(contentToSign, parameters, customContentSigner);
        CMSBuilder cmsBuilder = this.getCMSBuilder(parameters).setOriginalCMS(originalCms);
        CMS cms = cmsBuilder.createCMS(signerInfoGenerator, contentToSign);
        SignatureLevel signatureLevel = parameters.getSignatureLevel();
        if (!SignatureLevel.CAdES_BASELINE_B.equals((Object)signatureLevel)) {
            SignerInformation newSignerInformation = this.getNewSignerInformation(originalCms, cms);
            CAdESSignatureExtension extension = this.getExtensionProfile(parameters);
            cms = extension.extendCMSSignatures(cms, newSignerInformation, parameters);
        }
        DSSDocument signature = CMSUtils.writeToDSSDocument((CMS)cms, (DSSResourcesHandlerBuilder)this.resourcesHandlerBuilder);
        signature.setName(this.getFinalFileName(toSignDocument, SigningOperation.SIGN, parameters.getSignatureLevel(), parameters.getSignaturePackaging()));
        parameters.reinit();
        return signature;
    }

    public DSSDocument extendDocument(DSSDocument toExtendDocument, CAdESSignatureParameters parameters) {
        Objects.requireNonNull(toExtendDocument, "toExtendDocument is not defined!");
        Objects.requireNonNull(parameters, "Cannot extend the signature. SignatureParameters are not defined!");
        CAdESSignatureExtension extension = this.getExtensionProfile(parameters);
        DSSDocument dssDocument = extension.extendSignatures(toExtendDocument, parameters);
        dssDocument.setName(this.getFinalFileName(toExtendDocument, SigningOperation.EXTEND, parameters.getSignatureLevel()));
        return dssDocument;
    }

    private DSSDocument getContentToSign(DSSDocument toSignDocument, CAdESSignatureParameters parameters, CMS originalCms) {
        List detachedContents = parameters.getDetachedContents();
        if (Utils.isCollectionNotEmpty((Collection)detachedContents)) {
            return (DSSDocument)detachedContents.get(0);
        }
        if (originalCms == null) {
            return toSignDocument;
        }
        return this.getSignedContent(originalCms);
    }

    private DSSDocument getSignedContent(CMS cms) {
        if (cms.isDetachedSignature()) {
            throw new IllegalArgumentException("Detached content shall be provided on parallel signing of a detached signature! Please use cadesSignatureParameters#setDetachedContents method to provide original files.");
        }
        return cms.getSignedContent();
    }

    private SignerInformation getNewSignerInformation(CMS originalCMS, CMS newCMS) {
        Collection signers = newCMS.getSignerInfos().getSigners();
        if (originalCMS != null) {
            for (SignerInformation signerInformation : signers) {
                if (this.containsSignerInfo(originalCMS, signerInformation)) continue;
                return signerInformation;
            }
        }
        return (SignerInformation)signers.iterator().next();
    }

    private boolean containsSignerInfo(CMS cms, SignerInformation signerInformationToFind) {
        for (SignerInformation signerInformation : cms.getSignerInfos()) {
            if (signerInformationToFind.toASN1Structure() != signerInformation.toASN1Structure()) continue;
            return true;
        }
        return false;
    }

    private CAdESSignatureExtension getExtensionProfile(CAdESSignatureParameters parameters) {
        CAdESLevelBaselineT cadesSignatureExtension;
        SignatureLevel signatureLevel = parameters.getSignatureLevel();
        Objects.requireNonNull(signatureLevel, "SignatureLevel must be defined!");
        switch (signatureLevel) {
            case CAdES_BASELINE_T: {
                cadesSignatureExtension = new CAdESLevelBaselineT(this.tspSource, this.certificateVerifier);
                break;
            }
            case CAdES_BASELINE_LT: {
                cadesSignatureExtension = new CAdESLevelBaselineLT(this.tspSource, this.certificateVerifier);
                break;
            }
            case CAdES_BASELINE_LTA: {
                cadesSignatureExtension = new CAdESLevelBaselineLTA(this.tspSource, this.certificateVerifier);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported signature format '%s' for extension.", signatureLevel));
            }
        }
        ((CAdESSignatureExtension)cadesSignatureExtension).setResourcesHandlerBuilder(this.resourcesHandlerBuilder);
        return cadesSignatureExtension;
    }

    private CMS getOriginalCMS(DSSDocument dssDocument, CAdESSignatureParameters parameters) {
        CMS cms = null;
        if (parameters.isParallelSignature() && !(dssDocument instanceof DigestDocument) && DSSASN1Utils.isASN1SequenceTag((byte)DSSUtils.readFirstByte((DSSDocument)dssDocument))) {
            try {
                cms = CMSUtils.parseToCMS((DSSDocument)dssDocument);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (cms != null) {
                this.assertSignaturePossible(cms, parameters);
            }
        }
        return cms;
    }

    private void assertSignaturePossible(CMS cms, CAdESSignatureParameters parameters) {
        if (cms.isDetachedSignature() != (SignaturePackaging.DETACHED == parameters.getSignaturePackaging())) {
            throw new IllegalArgumentException(String.format("Unable to create a parallel signature with packaging '%s' which is different than the one used in the original signature!", parameters.getSignaturePackaging()));
        }
        for (SignerInformation signerInformation : cms.getSignerInfos()) {
            if (!CAdESUtils.containsEvidenceRecord(signerInformation)) continue;
            throw new IllegalInputException("Signature is not possible due to the CMS containing an evidence record unsigned attribute.");
        }
    }

    private CMSBuilder getCMSBuilder(CAdESSignatureParameters parameters) {
        return new CMSBuilder().setSigningCertificate(parameters.getSigningCertificate()).setCertificateChain(parameters.getCertificateChain()).setGenerateWithoutCertificates(parameters.isGenerateTBSWithoutCertificate()).setTrustAnchorBPPolicy(parameters.bLevel().isTrustAnchorBPPolicy()).setTrustedCertificateSource((CertificateSource)this.certificateVerifier.getTrustedCertSources()).setEncapsulate(this.isEncapsulateSignerData(parameters));
    }

    private boolean isEncapsulateSignerData(CAdESSignatureParameters signatureParameters) {
        return !SignaturePackaging.DETACHED.equals((Object)signatureParameters.getSignaturePackaging());
    }

    private void assertSignaturePackaging(SignaturePackaging packaging) {
        if (packaging != SignaturePackaging.ENVELOPING && packaging != SignaturePackaging.DETACHED) {
            throw new IllegalArgumentException("Unsupported signature packaging: " + packaging);
        }
    }

    public DSSDocument addSignaturePolicyStore(DSSDocument document, SignaturePolicyStore signaturePolicyStore) {
        Objects.requireNonNull(document, "The document cannot be null");
        Objects.requireNonNull(signaturePolicyStore, "The signaturePolicyStore cannot be null");
        CAdESSignaturePolicyStoreBuilder builder = this.getCAdESSignaturePolicyStoreBuilder();
        DSSDocument documentWithPolicyStore = builder.addSignaturePolicyStore(document, signaturePolicyStore);
        documentWithPolicyStore.setName(this.getFinalFileName(document, SigningOperation.EXTEND, null));
        return documentWithPolicyStore;
    }

    protected CAdESSignaturePolicyStoreBuilder getCAdESSignaturePolicyStoreBuilder() {
        CAdESSignaturePolicyStoreBuilder builder = new CAdESSignaturePolicyStoreBuilder();
        builder.setResourcesHandlerBuilder(this.resourcesHandlerBuilder);
        return builder;
    }

    public ToBeSigned getDataToBeCounterSigned(DSSDocument signatureDocument, CAdESCounterSignatureParameters parameters) {
        Objects.requireNonNull(signatureDocument, "signatureDocument cannot be null!");
        Objects.requireNonNull(parameters, "parameters cannot be null!");
        Objects.requireNonNull(parameters.getSignatureIdToCounterSign(), "The signature to be counter-signed must be specified");
        this.assertSigningCertificateValid(parameters);
        this.assertCounterSignaturePossible(parameters);
        CAdESCounterSignatureBuilder counterSignatureBuilder = this.getCAdESCounterSignatureBuilder();
        SignerInformation signerInfoToCounterSign = counterSignatureBuilder.getSignerInformationToBeCounterSigned(signatureDocument, parameters);
        return this.getDataToBeCounterSigned(signerInfoToCounterSign, (CAdESSignatureParameters)parameters);
    }

    public ToBeSigned getDataToBeCounterSigned(SignerInformation signerInfoToCounterSign, CAdESSignatureParameters parameters) {
        SignatureAlgorithm signatureAlgorithm = parameters.getSignatureAlgorithm();
        CustomContentSigner customContentSigner = new CustomContentSigner(signatureAlgorithm.getJCEId());
        CAdESCounterSignatureBuilder counterSignatureBuilder = this.getCAdESCounterSignatureBuilder();
        counterSignatureBuilder.generateCounterSignature(signerInfoToCounterSign, parameters, customContentSigner);
        return new ToBeSigned(customContentSigner.getOutputStream().toByteArray());
    }

    public DSSDocument counterSignSignature(DSSDocument signatureDocument, CAdESCounterSignatureParameters parameters, SignatureValue signatureValue) {
        Objects.requireNonNull(signatureDocument, "signatureDocument cannot be null!");
        Objects.requireNonNull(parameters, "parameters cannot be null!");
        Objects.requireNonNull(parameters.getSignatureIdToCounterSign(), "The signature to be counter-signed must be specified");
        Objects.requireNonNull(signatureValue, "signatureValue cannot be null!");
        this.assertSigningCertificateValid(parameters);
        this.assertCounterSignaturePossible(parameters);
        signatureValue = this.ensureSignatureValue(parameters.getSignatureAlgorithm(), signatureValue);
        CMS originalCMS = CMSUtils.parseToCMS((DSSDocument)signatureDocument);
        CAdESCounterSignatureBuilder counterSignatureBuilder = this.getCAdESCounterSignatureBuilder();
        DSSDocument counterSigned = counterSignatureBuilder.addCounterSignature(originalCMS, parameters, signatureValue);
        counterSigned.setName(this.getFinalFileName(signatureDocument, SigningOperation.COUNTER_SIGN, parameters.getSignatureLevel()));
        counterSigned.setMimeType(signatureDocument.getMimeType());
        return counterSigned;
    }

    protected CAdESCounterSignatureBuilder getCAdESCounterSignatureBuilder() {
        CAdESCounterSignatureBuilder counterSignatureBuilder = new CAdESCounterSignatureBuilder(this.certificateVerifier);
        counterSignatureBuilder.setResourcesHandlerBuilder(this.resourcesHandlerBuilder);
        return counterSignatureBuilder;
    }

    public DSSDocument addSignatureEvidenceRecord(DSSDocument signatureDocument, DSSDocument evidenceRecordDocument, CAdESEvidenceRecordIncorporationParameters parameters) {
        Objects.requireNonNull(signatureDocument, "The signature document cannot be null");
        Objects.requireNonNull(evidenceRecordDocument, "The evidence record document cannot be null");
        CAdESEmbeddedEvidenceRecordBuilder builder = new CAdESEmbeddedEvidenceRecordBuilder(this.certificateVerifier);
        DSSDocument signatureWithEvidenceRecord = builder.addEvidenceRecord(signatureDocument, evidenceRecordDocument, parameters);
        signatureWithEvidenceRecord.setName(this.getFinalFileName(signatureDocument, SigningOperation.ADD_EVIDENCE_RECORD));
        signatureWithEvidenceRecord.setMimeType(signatureDocument.getMimeType());
        return signatureWithEvidenceRecord;
    }

    private void assertCounterSignaturePossible(CAdESCounterSignatureParameters parameters) {
        if (!SignatureLevel.CAdES_BASELINE_B.equals((Object)parameters.getSignatureLevel())) {
            throw new UnsupportedOperationException(String.format("A counter signature with a level '%s' is not supported! Please, use CAdES-BASELINE-B", parameters.getSignatureLevel()));
        }
    }
}

