/*
 * Decompiled with CFR 0.152.
 */
package zio.nio.charset;

import java.io.Serializable;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichFloat$;
import zio.CanFail$;
import zio.Chunk;
import zio.Chunk$;
import zio.ZIO;
import zio.ZIO$;
import zio.nio.Buffer$;
import zio.nio.ByteBuffer;
import zio.nio.CharBuffer;
import zio.nio.charset.Charset;
import zio.nio.charset.Charset$;
import zio.nio.charset.CharsetEncoder;
import zio.nio.charset.CoderResult;
import zio.nio.charset.CoderResult$;
import zio.nio.charset.CoderResult$Overflow$;
import zio.nio.charset.CoderResult$Underflow$;
import zio.stream.ZChannel$;
import zio.stream.ZPipeline;
import zio.stream.ZPipeline$;

public final class CharsetEncoder$ {
    public static final CharsetEncoder$ MODULE$ = new CharsetEncoder$();

    public java.nio.charset.CharsetEncoder fromJava(java.nio.charset.CharsetEncoder javaEncoder) {
        return javaEncoder;
    }

    public final float averageBytesPerChar$extension(java.nio.charset.CharsetEncoder $this) {
        return $this.averageBytesPerChar();
    }

    public final Charset charset$extension(java.nio.charset.CharsetEncoder $this) {
        return Charset$.MODULE$.fromJava($this.charset());
    }

    public final ZIO<Object, CharacterCodingException, ByteBuffer> encode$extension(java.nio.charset.CharsetEncoder $this, CharBuffer in, Object trace) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(in.withJavaBuffer((Function1 & Serializable)jBuf -> ZIO$.MODULE$.attempt((Function0 & Serializable)() -> Buffer$.MODULE$.byteFromJava($this.encode((java.nio.CharBuffer)jBuf)), trace), trace)), ClassTag$.MODULE$.apply(CharacterCodingException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public final ZIO<Object, Nothing$, CoderResult> encode$extension(java.nio.charset.CharsetEncoder $this, CharBuffer in, ByteBuffer out, boolean endOfInput, Object trace) {
        return in.withJavaBuffer((Function1 & Serializable)jIn -> out.withJavaBuffer((Function1 & Serializable)jOut -> ZIO$.MODULE$.succeed((Function0 & Serializable)() -> CoderResult$.MODULE$.fromJava($this.encode((java.nio.CharBuffer)jIn, (java.nio.ByteBuffer)jOut, endOfInput)), trace), trace), trace);
    }

    public final ZIO<Object, Nothing$, CoderResult> flush$extension(java.nio.charset.CharsetEncoder $this, ByteBuffer out, Object trace) {
        return out.withJavaBuffer((Function1 & Serializable)jOut -> ZIO$.MODULE$.succeed((Function0 & Serializable)() -> CoderResult$.MODULE$.fromJava($this.flush((java.nio.ByteBuffer)jOut)), trace), trace);
    }

    public final ZIO<Object, Nothing$, CodingErrorAction> malformedInputAction$extension(java.nio.charset.CharsetEncoder $this, Object trace) {
        return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> $this.malformedInputAction(), trace);
    }

    public final ZIO<Object, Nothing$, BoxedUnit> onMalformedInput$extension(java.nio.charset.CharsetEncoder $this, CodingErrorAction errorAction, Object trace) {
        return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> $this.onMalformedInput(errorAction), trace).unit(trace);
    }

    public final ZIO<Object, Nothing$, CodingErrorAction> unmappableCharacterAction$extension(java.nio.charset.CharsetEncoder $this, Object trace) {
        return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> $this.unmappableCharacterAction(), trace);
    }

    public final ZIO<Object, Nothing$, BoxedUnit> onUnmappableCharacter$extension(java.nio.charset.CharsetEncoder $this, CodingErrorAction errorAction, Object trace) {
        return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> $this.onUnmappableCharacter(errorAction), trace).unit(trace);
    }

    public final float maxCharsPerByte$extension(java.nio.charset.CharsetEncoder $this) {
        return $this.maxBytesPerChar();
    }

    public final ZIO<Object, Nothing$, Chunk<Object>> replacement$extension(java.nio.charset.CharsetEncoder $this, Object trace) {
        return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> Chunk$.MODULE$.fromArray((Object)$this.replacement()), trace);
    }

    public final ZIO<Object, Nothing$, BoxedUnit> replaceWith$extension(java.nio.charset.CharsetEncoder $this, Chunk<Object> replacement, Object trace) {
        return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> $this.replaceWith((byte[])replacement.toArray((ClassTag)ClassTag$.MODULE$.Byte())), trace).unit(trace);
    }

    public final ZIO<Object, Nothing$, BoxedUnit> reset$extension(java.nio.charset.CharsetEncoder $this, Object trace) {
        return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> $this.reset(), trace).unit(trace);
    }

    public final ZPipeline<Object, CharacterCodingException, Object, Object> transducer$extension(java.nio.charset.CharsetEncoder $this, int bufSize, Object trace) {
        ZIO push = this.reset$extension($this, trace).flatMap((Function1 & Serializable)x$8 -> Buffer$.MODULE$.char(RichFloat$.MODULE$.round$extension(Predef$.MODULE$.floatWrapper((float)bufSize / MODULE$.averageBytesPerChar$extension($this))), trace).flatMap((Function1 & Serializable)charBuffer -> Buffer$.MODULE$.byte(bufSize, trace).map((Function1 & Serializable)byteBuffer -> (Function1 & Serializable)x$1 -> (ZIO)x$1.map((Function1 & Serializable)inChunk -> CharsetEncoder$.encodeChunk$1(inChunk, trace, charBuffer, $this, byteBuffer, trace)).getOrElse((Function0 & Serializable)() -> charBuffer.flip(trace).$times$greater((Function0 & Serializable)() -> CharsetEncoder$.endOfInput$2(trace, $this, charBuffer, byteBuffer, trace).flatMap((Function1 & Serializable)encodedBytes -> CharsetEncoder$.flushRemaining$1(trace, $this, byteBuffer, charBuffer, trace).map((Function1 & Serializable)x$7 -> encodedBytes.$plus$plus(x$7), trace), trace), trace).$less$times((Function0 & Serializable)() -> charBuffer.clear(trace), trace).$less$times((Function0 & Serializable)() -> byteBuffer.clear(trace), trace)), trace), trace), trace);
        if (bufSize < 50) {
            return ZPipeline$.MODULE$.fromChannel((Function0 & Serializable)() -> ZChannel$.MODULE$.fromZIO((Function0 & Serializable)() -> ZIO$.MODULE$.die((Function0 & Serializable)() -> new IllegalArgumentException(new StringBuilder(30).append("Buffer size is ").append(bufSize).append(", must be >= 50").toString()), trace), trace));
        }
        return ZPipeline$.MODULE$.fromPush((Function0 & Serializable)() -> push, trace);
    }

    public final int transducer$default$1$extension(java.nio.charset.CharsetEncoder $this) {
        return 5000;
    }

    public final int hashCode$extension(java.nio.charset.CharsetEncoder $this) {
        return $this.hashCode();
    }

    public final boolean equals$extension(java.nio.charset.CharsetEncoder $this, Object x$1) {
        if (x$1 instanceof CharsetEncoder) {
            java.nio.charset.CharsetEncoder charsetEncoder = x$1 == null ? null : ((CharsetEncoder)x$1).javaEncoder();
            java.nio.charset.CharsetEncoder charsetEncoder2 = $this;
            if (!(charsetEncoder2 != null ? !charsetEncoder2.equals(charsetEncoder) : charsetEncoder != null)) {
                return true;
            }
        }
        return false;
    }

    private static final ZIO handleCoderResult$1(CoderResult coderResult, CharBuffer charBuffer$1, Object trace$4, ByteBuffer byteBuffer$1) {
        if (CoderResult$Underflow$.MODULE$.equals(coderResult) ? true : CoderResult$Overflow$.MODULE$.equals(coderResult)) {
            return charBuffer$1.compact(trace$4).$times$greater((Function0 & Serializable)() -> byteBuffer$1.flip(trace$4), trace$4).$times$greater((Function0 & Serializable)() -> byteBuffer$1.getChunk(byteBuffer$1.getChunk$default$1(), trace$4), trace$4).$less$times((Function0 & Serializable)() -> byteBuffer$1.clear(trace$4), trace$4);
        }
        if (coderResult instanceof CoderResult.Malformed) {
            int length = ((CoderResult.Malformed)coderResult).length();
            return ZIO$.MODULE$.fail((Function0 & Serializable)() -> new MalformedInputException(length), trace$4);
        }
        if (coderResult instanceof CoderResult.Unmappable) {
            int length = ((CoderResult.Unmappable)coderResult).length();
            return ZIO$.MODULE$.fail((Function0 & Serializable)() -> new UnmappableCharacterException(length), trace$4);
        }
        throw new MatchError((Object)coderResult);
    }

    public static final /* synthetic */ Tuple2 $anonfun$transducer$11(Chunk inChars$1, int bufRemaining) {
        Tuple2 tuple2;
        Tuple2 tuple22 = tuple2 = inChars$1.length() > bufRemaining ? inChars$1.splitAt(bufRemaining) : new Tuple2((Object)inChars$1, (Object)Chunk$.MODULE$.empty());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Chunk cfr_ignored_0 = (Chunk)tuple2._1();
        Chunk cfr_ignored_1 = (Chunk)tuple2._2();
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)bufRemaining), (Object)tuple2);
    }

    private static final ZIO encodeChunk$1(Chunk inChars, Object trace, CharBuffer charBuffer$1, java.nio.charset.CharsetEncoder $this$11, ByteBuffer byteBuffer$1, Object trace$4) {
        return charBuffer$1.remaining(trace).map((Function1 & Serializable)bufRemaining -> CharsetEncoder$.$anonfun$transducer$11(inChars, BoxesRunTime.unboxToInt((Object)bufRemaining)), trace).flatMap((Function1 & Serializable)x$6 -> {
            Tuple2 tuple2;
            if (x$6 != null && (tuple2 = (Tuple2)x$6._2()) != null) {
                Chunk decodeChars = (Chunk)tuple2._1();
                Chunk remainingChars = (Chunk)tuple2._2();
                return charBuffer$1.putChunk(decodeChars, trace).flatMap((Function1 & Serializable)x$5 -> charBuffer$1.flip(trace).flatMap((Function1 & Serializable)x$4 -> MODULE$.encode$extension($this$11, charBuffer$1, byteBuffer$1, false, trace).flatMap((Function1 & Serializable)result -> CharsetEncoder$.handleCoderResult$1(result, charBuffer$1, trace$4, byteBuffer$1).flatMap((Function1 & Serializable)encodedBytes -> (remainingChars.isEmpty() ? ZIO$.MODULE$.succeed((Function0 & Serializable)() -> Chunk$.MODULE$.empty(), trace) : CharsetEncoder$.encodeChunk$1(remainingChars, trace, charBuffer$1, $this$11, byteBuffer$1, trace$4)).map((Function1 & Serializable)remainderBytes -> encodedBytes.$plus$plus(remainderBytes), trace), trace), trace), trace), trace);
            }
            throw new MatchError(x$6);
        }, trace);
    }

    private static final ZIO endOfInput$2(Object trace, java.nio.charset.CharsetEncoder $this$11, CharBuffer charBuffer$1, ByteBuffer byteBuffer$1, Object trace$4) {
        return MODULE$.encode$extension($this$11, charBuffer$1, byteBuffer$1, true, trace).flatMap((Function1 & Serializable)result -> CharsetEncoder$.handleCoderResult$1(result, charBuffer$1, trace$4, byteBuffer$1).flatMap((Function1 & Serializable)encodedBytes -> {
            CoderResult coderResult = result;
            CoderResult$Overflow$ coderResult$Overflow$ = CoderResult$Overflow$.MODULE$;
            return (coderResult != null && coderResult.equals(coderResult$Overflow$) ? CharsetEncoder$.endOfInput$2(trace, $this$11, charBuffer$1, byteBuffer$1, trace$4) : ZIO$.MODULE$.succeed((Function0 & Serializable)() -> Chunk$.MODULE$.empty(), trace)).map((Function1 & Serializable)remainderBytes -> encodedBytes.$plus$plus(remainderBytes), trace);
        }, trace), trace);
    }

    private static final ZIO flushRemaining$1(Object trace, java.nio.charset.CharsetEncoder $this$11, ByteBuffer byteBuffer$1, CharBuffer charBuffer$1, Object trace$4) {
        return MODULE$.flush$extension($this$11, byteBuffer$1, trace).flatMap((Function1 & Serializable)result -> CharsetEncoder$.handleCoderResult$1(result, charBuffer$1, trace$4, byteBuffer$1).flatMap((Function1 & Serializable)encodedBytes -> {
            CoderResult coderResult = result;
            CoderResult$Overflow$ coderResult$Overflow$ = CoderResult$Overflow$.MODULE$;
            return (coderResult != null && coderResult.equals(coderResult$Overflow$) ? CharsetEncoder$.flushRemaining$1(trace, $this$11, byteBuffer$1, charBuffer$1, trace$4) : ZIO$.MODULE$.succeed((Function0 & Serializable)() -> Chunk$.MODULE$.empty(), trace)).map((Function1 & Serializable)remainderBytes -> encodedBytes.$plus$plus(remainderBytes), trace);
        }, trace), trace);
    }

    private CharsetEncoder$() {
    }
}

