/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.redis;

import dev.langchain4j.store.embedding.redis.MetricType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import redis.clients.jedis.search.schemafields.SchemaField;
import redis.clients.jedis.search.schemafields.TextField;
import redis.clients.jedis.search.schemafields.VectorField;

class RedisSchema {
    public static final String SCORE_FIELD_NAME = "vector_score";
    private static final String JSON_PATH_PREFIX = "$.";
    private static final VectorField.VectorAlgorithm DEFAULT_VECTOR_ALGORITHM = VectorField.VectorAlgorithm.HNSW;
    private static final MetricType DEFAULT_METRIC_TYPE = MetricType.COSINE;
    private String indexName;
    private String prefix;
    private String vectorFieldName;
    private String scalarFieldName;
    private List<String> metadataFieldsName;
    private VectorField.VectorAlgorithm vectorAlgorithm;
    private int dimension;
    private MetricType metricType;

    public RedisSchema(int dimension) {
        this.dimension = dimension;
    }

    public SchemaField[] toSchemaFields() {
        HashMap<String, Object> vectorAttrs = new HashMap<String, Object>();
        vectorAttrs.put("DIM", this.dimension);
        vectorAttrs.put("DISTANCE_METRIC", this.metricType.name());
        vectorAttrs.put("TYPE", "FLOAT32");
        vectorAttrs.put("INITIAL_CAP", 5);
        ArrayList<Object> fields = new ArrayList<Object>();
        fields.add(TextField.of((String)(JSON_PATH_PREFIX + this.scalarFieldName)).as(this.scalarFieldName).weight(1.0));
        fields.add(VectorField.builder().fieldName(JSON_PATH_PREFIX + this.vectorFieldName).algorithm(this.vectorAlgorithm).attributes(vectorAttrs).as(this.vectorFieldName).build());
        if (this.metadataFieldsName != null && !this.metadataFieldsName.isEmpty()) {
            for (String metadataFieldName : this.metadataFieldsName) {
                fields.add(TextField.of((String)(JSON_PATH_PREFIX + metadataFieldName)).as(metadataFieldName).weight(1.0));
            }
        }
        return fields.toArray(new SchemaField[0]);
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getVectorFieldName() {
        return this.vectorFieldName;
    }

    public String getScalarFieldName() {
        return this.scalarFieldName;
    }

    public List<String> getMetadataFieldsName() {
        return this.metadataFieldsName;
    }

    private static String $default$prefix() {
        return "embedding:";
    }

    private static String $default$vectorFieldName() {
        return "vector";
    }

    private static String $default$scalarFieldName() {
        return "text";
    }

    private static List<String> $default$metadataFieldsName() {
        return new ArrayList<String>();
    }

    private static VectorField.VectorAlgorithm $default$vectorAlgorithm() {
        return DEFAULT_VECTOR_ALGORITHM;
    }

    private static MetricType $default$metricType() {
        return DEFAULT_METRIC_TYPE;
    }

    public static RedisSchemaBuilder builder() {
        return new RedisSchemaBuilder();
    }

    public RedisSchema(String indexName, String prefix, String vectorFieldName, String scalarFieldName, List<String> metadataFieldsName, VectorField.VectorAlgorithm vectorAlgorithm, int dimension, MetricType metricType) {
        this.indexName = indexName;
        this.prefix = prefix;
        this.vectorFieldName = vectorFieldName;
        this.scalarFieldName = scalarFieldName;
        this.metadataFieldsName = metadataFieldsName;
        this.vectorAlgorithm = vectorAlgorithm;
        this.dimension = dimension;
        this.metricType = metricType;
    }

    public static class RedisSchemaBuilder {
        private String indexName;
        private boolean prefix$set;
        private String prefix$value;
        private boolean vectorFieldName$set;
        private String vectorFieldName$value;
        private boolean scalarFieldName$set;
        private String scalarFieldName$value;
        private boolean metadataFieldsName$set;
        private List<String> metadataFieldsName$value;
        private boolean vectorAlgorithm$set;
        private VectorField.VectorAlgorithm vectorAlgorithm$value;
        private int dimension;
        private boolean metricType$set;
        private MetricType metricType$value;

        RedisSchemaBuilder() {
        }

        public RedisSchemaBuilder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public RedisSchemaBuilder prefix(String prefix) {
            this.prefix$value = prefix;
            this.prefix$set = true;
            return this;
        }

        public RedisSchemaBuilder vectorFieldName(String vectorFieldName) {
            this.vectorFieldName$value = vectorFieldName;
            this.vectorFieldName$set = true;
            return this;
        }

        public RedisSchemaBuilder scalarFieldName(String scalarFieldName) {
            this.scalarFieldName$value = scalarFieldName;
            this.scalarFieldName$set = true;
            return this;
        }

        public RedisSchemaBuilder metadataFieldsName(List<String> metadataFieldsName) {
            this.metadataFieldsName$value = metadataFieldsName;
            this.metadataFieldsName$set = true;
            return this;
        }

        public RedisSchemaBuilder vectorAlgorithm(VectorField.VectorAlgorithm vectorAlgorithm) {
            this.vectorAlgorithm$value = vectorAlgorithm;
            this.vectorAlgorithm$set = true;
            return this;
        }

        public RedisSchemaBuilder dimension(int dimension) {
            this.dimension = dimension;
            return this;
        }

        public RedisSchemaBuilder metricType(MetricType metricType) {
            this.metricType$value = metricType;
            this.metricType$set = true;
            return this;
        }

        public RedisSchema build() {
            String prefix$value = this.prefix$value;
            if (!this.prefix$set) {
                prefix$value = RedisSchema.$default$prefix();
            }
            String vectorFieldName$value = this.vectorFieldName$value;
            if (!this.vectorFieldName$set) {
                vectorFieldName$value = RedisSchema.$default$vectorFieldName();
            }
            String scalarFieldName$value = this.scalarFieldName$value;
            if (!this.scalarFieldName$set) {
                scalarFieldName$value = RedisSchema.$default$scalarFieldName();
            }
            List metadataFieldsName$value = this.metadataFieldsName$value;
            if (!this.metadataFieldsName$set) {
                metadataFieldsName$value = RedisSchema.$default$metadataFieldsName();
            }
            VectorField.VectorAlgorithm vectorAlgorithm$value = this.vectorAlgorithm$value;
            if (!this.vectorAlgorithm$set) {
                vectorAlgorithm$value = RedisSchema.$default$vectorAlgorithm();
            }
            MetricType metricType$value = this.metricType$value;
            if (!this.metricType$set) {
                metricType$value = RedisSchema.$default$metricType();
            }
            return new RedisSchema(this.indexName, prefix$value, vectorFieldName$value, scalarFieldName$value, metadataFieldsName$value, vectorAlgorithm$value, this.dimension, metricType$value);
        }

        public String toString() {
            return "RedisSchema.RedisSchemaBuilder(indexName=" + this.indexName + ", prefix$value=" + this.prefix$value + ", vectorFieldName$value=" + this.vectorFieldName$value + ", scalarFieldName$value=" + this.scalarFieldName$value + ", metadataFieldsName$value=" + this.metadataFieldsName$value + ", vectorAlgorithm$value=" + this.vectorAlgorithm$value + ", dimension=" + this.dimension + ", metricType$value=" + (Object)((Object)this.metricType$value) + ")";
        }
    }
}

