/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.message;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ChatMessageType;
import dev.langchain4j.internal.Utils;
import java.util.Objects;

public class AiMessage
extends ChatMessage {
    private final ToolExecutionRequest toolExecutionRequest;

    public AiMessage(String text) {
        this(text, null);
    }

    public AiMessage(String text, ToolExecutionRequest toolExecutionRequest) {
        super(text);
        this.toolExecutionRequest = toolExecutionRequest;
    }

    public ToolExecutionRequest toolExecutionRequest() {
        return this.toolExecutionRequest;
    }

    @Override
    public ChatMessageType type() {
        return ChatMessageType.AI;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AiMessage that = (AiMessage)o;
        return Objects.equals(this.text, that.text) && Objects.equals(this.toolExecutionRequest, that.toolExecutionRequest);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.toolExecutionRequest);
    }

    public String toString() {
        return "AiMessage { text = " + Utils.quoted(this.text) + " toolExecutionRequest = " + this.toolExecutionRequest + " }";
    }

    public static AiMessage from(String text) {
        return new AiMessage(text);
    }

    public static AiMessage from(ToolExecutionRequest toolExecutionRequest) {
        return new AiMessage(null, toolExecutionRequest);
    }

    public static AiMessage aiMessage(String text) {
        return AiMessage.from(text);
    }

    public static AiMessage aiMessage(ToolExecutionRequest toolExecutionRequest) {
        return AiMessage.from(toolExecutionRequest);
    }
}

