/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.store.embedding.neo4j;

import dev.langchain4j.community.store.embedding.ParentChildEmbeddingStoreIngestor;
import dev.langchain4j.community.store.embedding.neo4j.Neo4jEmbeddingStore;
import dev.langchain4j.data.document.DocumentSplitter;
import dev.langchain4j.data.document.DocumentTransformer;
import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.data.segment.TextSegmentTransformer;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.PromptTemplate;
import dev.langchain4j.store.embedding.EmbeddingStore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Session;

public class Neo4jEmbeddingStoreIngestor
extends ParentChildEmbeddingStoreIngestor {
    public static final String DEFAULT_PARENT_ID_KEY = "parentId";
    protected final Driver driver;
    protected final String query;
    protected final String parentIdKey;
    protected final Map<String, Object> params;
    protected Neo4jEmbeddingStore neo4jEmbeddingStore;
    protected final String userPrompt;
    protected final String systemPrompt;
    protected final ChatModel questionModel;

    public Neo4jEmbeddingStoreIngestor(Builder builder) {
        this(builder.documentTransformer, builder.documentSplitter, builder.textSegmentTransformer, builder.childTextSegmentTransformer, builder.embeddingModel, (Neo4jEmbeddingStore)builder.embeddingStore, builder.documentChildSplitter, builder.driver, builder.query, builder.parentIdKey, builder.params, builder.systemPrompt, builder.userPrompt, builder.questionModel);
    }

    public Neo4jEmbeddingStoreIngestor(DocumentTransformer documentTransformer, DocumentSplitter documentSplitter, TextSegmentTransformer textSegmentTransformer, TextSegmentTransformer childTextSegmentTransformer, EmbeddingModel embeddingModel, Neo4jEmbeddingStore embeddingStore, DocumentSplitter documentChildSplitter, Driver driver, String query, String parentIdKey, Map<String, Object> params, String systemPrompt, String userPrompt, ChatModel questionModel) {
        super(documentTransformer, documentSplitter, textSegmentTransformer, childTextSegmentTransformer, embeddingModel, (EmbeddingStore)embeddingStore, documentChildSplitter);
        this.driver = (Driver)ValidationUtils.ensureNotNull((Object)driver, (String)"driver");
        this.query = (String)ValidationUtils.ensureNotNull((Object)query, (String)"query");
        this.params = Utils.copy(params);
        this.parentIdKey = (String)Utils.getOrDefault((Object)parentIdKey, (Object)DEFAULT_PARENT_ID_KEY);
        this.neo4jEmbeddingStore = embeddingStore;
        this.textSegmentTransformer = (TextSegmentTransformer)Utils.getOrDefault((Object)textSegmentTransformer, (Object)this.getTextSegmentTransformer());
        this.childTextSegmentTransformer = (TextSegmentTransformer)Utils.getOrDefault((Object)childTextSegmentTransformer, (Object)this.getDefaultChildTextSegmentTransformer());
        this.userPrompt = userPrompt;
        this.systemPrompt = systemPrompt;
        this.questionModel = questionModel;
    }

    private TextSegmentTransformer getTextSegmentTransformer() {
        return segment -> {
            String text;
            TextSegment parentSegment = Neo4jEmbeddingStoreIngestor.getTextSegmentWithUniqueId(segment, this.neo4jEmbeddingStore.getIdProperty(), null);
            String textInput = parentSegment.text();
            Map metadataMap = segment.metadata().toMap();
            String parentId = "parent_" + String.valueOf(UUID.randomUUID());
            metadataMap.put(this.parentIdKey, parentId);
            if (this.questionModel != null) {
                if (this.systemPrompt == null || this.userPrompt == null) {
                    throw new RuntimeException("Prompts cannot be null: systemPrompt=" + this.systemPrompt + ", userPrompt=" + this.userPrompt);
                }
                SystemMessage systemMessage = Prompt.from((String)this.systemPrompt).toSystemMessage();
                PromptTemplate userTemplate = PromptTemplate.from((String)this.userPrompt);
                UserMessage userMessage = userTemplate.apply(Map.of("input", textInput)).toUserMessage();
                List<UserMessage> chatMessages = List.of(systemMessage, userMessage);
                text = this.questionModel.chat(chatMessages).aiMessage().text();
            } else {
                text = textInput;
            }
            metadataMap.putIfAbsent("text", text);
            HashMap<String, Map> params = new HashMap<String, Map>(Map.of("metadata", metadataMap));
            params.put(this.parentIdKey, (Map)((Object)parentId));
            this.getAdditionalParams(parentId);
            metadataMap.putAll(this.params);
            try (Session session = this.driver.session();){
                session.run(this.query, params);
            }
            return segment;
        };
    }

    private TextSegmentTransformer getDefaultChildTextSegmentTransformer() {
        return segment -> Neo4jEmbeddingStoreIngestor.getTextSegmentWithUniqueId(segment, this.neo4jEmbeddingStore.getIdProperty(), this.parentIdKey);
    }

    private void getAdditionalParams(String parentId) {
        HashMap<String, Object> params = new HashMap<String, Object>(this.params);
        params.put(this.parentIdKey, parentId);
        this.neo4jEmbeddingStore.setAdditionalParams(params);
    }

    public static TextSegment getTextSegmentWithUniqueId(TextSegment segment, String idProperty, String parentId) {
        Object value;
        Metadata metadata1 = segment.metadata();
        Object idMeta = metadata1.toMap().get(idProperty);
        Object object = value = parentId == null ? Utils.randomUUID() : parentId + "_" + Utils.randomUUID();
        if (idMeta != null) {
            value = String.valueOf(idMeta) + "_" + (String)value;
        }
        metadata1.put(idProperty, (String)value);
        return segment;
    }

    public Neo4jEmbeddingStore getEmbeddingStore() {
        return this.neo4jEmbeddingStore;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ParentChildEmbeddingStoreIngestor.Builder<Builder> {
        protected Driver driver;
        protected String query;
        protected String parentIdKey;
        protected Map<String, Object> params;
        protected String systemPrompt;
        protected String userPrompt;
        protected ChatModel questionModel;

        public Builder driver(Driver driver) {
            this.driver = driver;
            return this.self();
        }

        public Builder query(String query) {
            this.query = query;
            return this.self();
        }

        public Builder parentIdKey(String parentIdKey) {
            this.parentIdKey = parentIdKey;
            return this.self();
        }

        public Builder params(Map<String, Object> params) {
            this.params = params;
            return this.self();
        }

        public Builder systemPrompt(String systemPrompt) {
            this.systemPrompt = systemPrompt;
            return this.self();
        }

        public Builder userPrompt(String userPrompt) {
            this.userPrompt = userPrompt;
            return this.self();
        }

        public Builder questionModel(ChatModel questionModel) {
            this.questionModel = questionModel;
            return this.self();
        }

        protected Builder self() {
            return this;
        }

        public Neo4jEmbeddingStoreIngestor build() {
            return new Neo4jEmbeddingStoreIngestor(this);
        }
    }
}

