/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.store.embedding.neo4j;

import dev.langchain4j.community.store.embedding.neo4j.Neo4jEmbeddingStore;
import dev.langchain4j.community.store.embedding.neo4j.Neo4jEmbeddingStoreIngestor;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.store.embedding.EmbeddingStore;

public class HypotheticalQuestionGraphIngestor
extends Neo4jEmbeddingStoreIngestor {
    public HypotheticalQuestionGraphIngestor(Builder builder) {
        super(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Neo4jEmbeddingStoreIngestor.Builder {
        private static final String DEFAULT_RETRIEVAL_QUERY = "MATCH (node)<-[:HAS_QUESTION]-(parent)\nWITH parent, max(score) AS score, node // deduplicate parents\nRETURN parent.text AS text, score, properties(node) AS metadata\n ORDER BY score DESC\nLIMIT $maxResults";
        private static final String DEFAULT_PARENT_QUERY = "    UNWIND $rows AS question\n    MATCH (p:QuestionChunk {parentId: $parentId})\n    WITH p, question\n    CREATE (q:%1$s {%2$s: question.%2$s})\n    SET q += question.%3$s\n    MERGE (q)<-[:HAS_QUESTION]-(p)\n    WITH q, question\n    CALL db.create.setNodeVectorProperty(q, $embeddingProperty, question.%4$s)\n    RETURN count(*)\n";
        private static final String DEFAULT_SYSTEM_PROMPT = "You are generating hypothetical questions based on the information found in the text.\nMake sure to provide full context in the generated questions.\n";
        private static final String DEFAULT_USER_PROMPT = "Use the given format to generate hypothetical questions from the following input:\n{{input}}\n\nHypothetical questions:\n";
        public static final String DEFAULT_CHUNK_CREATION_QUERY = "CREATE (:QuestionChunk $metadata)";

        private Neo4jEmbeddingStore defaultEmbeddingStore() {
            return Neo4jEmbeddingStore.builder().driver(this.driver).retrievalQuery(DEFAULT_RETRIEVAL_QUERY).entityCreationQuery(DEFAULT_PARENT_QUERY).label("Child").indexName("child_embedding_index").dimension(384).build();
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HypotheticalQuestionGraphIngestor build() {
            this.systemPrompt = (String)Utils.getOrDefault((Object)this.systemPrompt, (Object)DEFAULT_SYSTEM_PROMPT);
            this.userPrompt = (String)Utils.getOrDefault((Object)this.userPrompt, (Object)DEFAULT_USER_PROMPT);
            this.query = (String)Utils.getOrDefault((Object)this.query, (Object)DEFAULT_CHUNK_CREATION_QUERY);
            this.embeddingStore = (EmbeddingStore)Utils.getOrDefault((Object)this.embeddingStore, (Object)this.defaultEmbeddingStore());
            return new HypotheticalQuestionGraphIngestor(this);
        }
    }
}

