/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.maven;

import dev.hilla.maven.ParserClassPathConfiguration;
import dev.hilla.maven.ParserConfiguration;
import dev.hilla.maven.ParserException;
import dev.hilla.parser.core.Parser;
import dev.hilla.parser.core.ParserConfig;
import dev.hilla.parser.core.PluginConfiguration;
import dev.hilla.parser.core.PluginManager;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

final class ParserProcessor {
    private final Log logger;
    private final ParserConfiguration.PluginsProcessor pluginsProcessor = new ParserConfiguration.PluginsProcessor();
    private final MavenProject project;
    private Set<String> classPath;
    private String endpointAnnotationName = "dev.hilla.Endpoint";
    private String endpointExposedAnnotationName = "dev.hilla.EndpointExposed";
    private String openAPIPath;

    public ParserProcessor(MavenProject project, Log logger) {
        this.project = project;
        this.logger = logger;
        try {
            this.classPath = Stream.of(project.getCompileClasspathElements(), project.getRuntimeClasspathElements()).flatMap(Collection::stream).collect(Collectors.toSet());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new ParserException("Failed collecting Maven class path", e);
        }
    }

    public ParserProcessor classPath(@Nonnull ParserClassPathConfiguration classPath) {
        String value = Objects.requireNonNull(classPath).getValue();
        String delimiter = classPath.getDelimiter();
        Set<String> userDefinedClassPathElements = Set.of(value.split(delimiter));
        this.classPath = classPath.isOverride() ? userDefinedClassPathElements : Stream.of(this.classPath, userDefinedClassPathElements).flatMap(Collection::stream).collect(Collectors.toSet());
        return this;
    }

    public ParserProcessor endpointAnnotation(@Nonnull String endpointAnnotationName) {
        this.endpointAnnotationName = Objects.requireNonNull(endpointAnnotationName);
        return this;
    }

    public ParserProcessor endpointExposedAnnotation(@Nonnull String endpointExposedAnnotationName) {
        this.endpointExposedAnnotationName = Objects.requireNonNull(endpointExposedAnnotationName);
        return this;
    }

    public ParserProcessor openAPIBase(@Nonnull String openAPIPath) {
        this.openAPIPath = Objects.requireNonNull(openAPIPath);
        return this;
    }

    public ParserProcessor plugins(@Nonnull ParserConfiguration.Plugins plugins) {
        this.pluginsProcessor.setConfig(plugins);
        return this;
    }

    public OpenAPI process() {
        ParserConfig.Builder builder = new ParserConfig.Builder().classPath(this.classPath).endpointAnnotation(this.endpointAnnotationName).endpointExposedAnnotation(this.endpointExposedAnnotationName);
        this.preparePlugins(builder);
        this.prepareOpenAPIBase(builder);
        this.logger.debug((CharSequence)"Starting JVM Parser");
        return new Parser(builder.finish()).execute();
    }

    private void prepareOpenAPIBase(ParserConfig.Builder builder) {
        if (this.openAPIPath == null) {
            return;
        }
        try {
            Path path = Paths.get(this.project.getBasedir().getAbsolutePath(), this.openAPIPath);
            String fileName = path.getFileName().toString();
            if (!(fileName.endsWith("yml") || fileName.endsWith("yaml") || fileName.endsWith("json"))) {
                throw new IOException("No OpenAPI base file found");
            }
            builder.openAPISource(Files.readString(path), fileName.endsWith("json") ? ParserConfig.OpenAPIFileType.JSON : ParserConfig.OpenAPIFileType.YAML);
        }
        catch (IOException e) {
            throw new ParserException("Failed loading OpenAPI spec file", e);
        }
    }

    private void preparePlugins(ParserConfig.Builder builder) {
        List loadedPlugins = this.pluginsProcessor.process().stream().map(plugin -> PluginManager.load((String)plugin.getName(), (Integer)plugin.getOrder(), (PluginConfiguration)plugin.getConfiguration())).collect(Collectors.toList());
        builder.plugins(loadedPlugins);
    }
}

