/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.cbarchive.meta.omex;

import de.unirostock.sems.cbarchive.Utils;
import de.unirostock.sems.cbarchive.meta.omex.VCard;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class OmexDescription {
    private String description;
    private List<VCard> creators;
    private Date created;
    public List<Date> modified;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<VCard> getCreators() {
        return this.creators;
    }

    public Date getCreated() {
        return this.created;
    }

    public List<Date> getModified() {
        return this.modified;
    }

    public OmexDescription(String description) {
        this.creators = new ArrayList<VCard>();
        this.modified = new ArrayList<Date>();
        this.created = new Date();
        this.description = description;
    }

    public OmexDescription(List<VCard> creators, List<Date> modified, String description) {
        this.creators = creators;
        this.modified = modified;
        this.created = new Date();
        this.description = description;
    }

    public OmexDescription clone() {
        ArrayList<VCard> creators = new ArrayList<VCard>();
        for (VCard vc : this.creators) {
            creators.add(vc);
        }
        ArrayList<Date> modified = new ArrayList<Date>();
        for (Date d : this.modified) {
            modified.add(d);
        }
        return new OmexDescription(creators, modified, this.created, this.description);
    }

    public OmexDescription(VCard creator, Date created, String description) {
        this.creators = new ArrayList<VCard>();
        this.creators.add(creator);
        this.modified = new ArrayList<Date>();
        this.created = created;
        this.description = description;
    }

    public OmexDescription(List<VCard> creators, Date created, String description) {
        this.creators = creators;
        this.modified = new ArrayList<Date>();
        this.created = created;
        this.description = description;
    }

    public OmexDescription(List<VCard> creators, List<Date> modified, Date created, String description) {
        this.creators = creators;
        this.modified = modified;
        this.created = created;
        this.description = description;
    }

    public OmexDescription() {
        this.creators = new ArrayList<VCard>();
        this.modified = new ArrayList<Date>();
        this.created = new Date();
        this.description = null;
    }

    public OmexDescription(List<VCard> creators, List<Date> modified) {
        this.creators = creators;
        this.modified = modified;
        this.created = new Date();
        this.description = null;
    }

    public OmexDescription(VCard creator, Date created) {
        this.creators = new ArrayList<VCard>();
        this.creators.add(creator);
        this.modified = new ArrayList<Date>();
        this.created = created;
        this.description = null;
    }

    public OmexDescription(List<VCard> creators, Date created) {
        this.creators = creators;
        this.modified = new ArrayList<Date>();
        this.created = created;
        this.description = null;
    }

    public OmexDescription(List<VCard> creators, List<Date> modified, Date created) {
        this.creators = creators;
        this.modified = modified;
        this.created = created;
        this.description = null;
    }

    public boolean isEmpty() {
        boolean haveCreator = false;
        if (this.creators != null) {
            for (VCard vc : this.creators) {
                if (vc.isEmpty()) continue;
                haveCreator = true;
                break;
            }
        }
        return (this.description == null || this.description.length() <= 0) && !haveCreator && this.created == null;
    }

    public void toXML(Element parent) {
        if (this.modified == null) {
            this.modified = new ArrayList<Date>();
        }
        if (this.modified.size() < 1) {
            if (this.created == null) {
                this.created = new Date();
            }
            this.modified.add(this.created);
        }
        if (this.description != null && this.description.length() > 0) {
            Element description = new Element("description", Utils.dcNS);
            description.setText(this.description);
            parent.addContent((Content)description);
        }
        if (this.creators != null) {
            for (VCard vc : this.creators) {
                vc.toXml(parent);
            }
        }
        if (this.created != null) {
            Element created = new Element("created", Utils.dcNS);
            created.setAttribute("parseType", "Resource", Utils.rdfNS);
            Element W3CDTF = new Element("W3CDTF", Utils.dcNS);
            W3CDTF.setText(Utils.dateFormater.format(this.created));
            created.addContent((Content)W3CDTF);
            parent.addContent((Content)created);
        }
        for (Date date : this.modified) {
            Element modified = new Element("modified", Utils.dcNS);
            modified.setAttribute("parseType", "Resource", Utils.rdfNS);
            Element modW3CDTF = new Element("W3CDTF", Utils.dcNS);
            modW3CDTF.setText(Utils.dateFormater.format(date));
            modified.addContent((Content)modW3CDTF);
            parent.addContent((Content)modified);
        }
    }

    public OmexDescription(Element parent) throws ParseException {
        int i;
        this.creators = new ArrayList<VCard>();
        this.modified = new ArrayList<Date>();
        List<Element> list = Utils.getElementsByTagName(parent, "description", Utils.dcNS);
        if (list.size() > 0) {
            this.description = list.get(0).getText();
        }
        if ((list = Utils.getElementsByTagName(parent, "creator", Utils.dcNS)).size() > 0) {
            for (i = 0; i < list.size(); ++i) {
                this.creators.add(new VCard(list.get(i)));
            }
        }
        if ((list = Utils.getElementsByTagName(parent, "created", Utils.dcNS)).size() > 0 && (list = Utils.getElementsByTagName(list.get(0), "W3CDTF", Utils.dcNS)).size() > 0) {
            this.created = Utils.dateFormater.parse(list.get(0).getText());
        }
        if ((list = Utils.getElementsByTagName(parent, "modified", Utils.dcNS)).size() > 0) {
            for (i = 0; i < list.size(); ++i) {
                List<Element> date = Utils.getElementsByTagName(list.get(i), "W3CDTF", Utils.dcNS);
                if (date.size() <= 0) continue;
                this.modified.add(Utils.dateFormater.parse(date.get(0).getText()));
            }
        }
    }

    public JSONObject toJsonDescription() {
        JSONObject descr = new JSONObject();
        descr.put((Object)"description", (Object)this.description);
        JSONArray array = new JSONArray();
        for (VCard c : this.creators) {
            array.add(c.toJsonObject());
        }
        descr.put((Object)"creators", (Object)array);
        descr.put((Object)"created", (Object)Utils.dateFormater.format(this.created));
        array = new JSONArray();
        for (Date d : this.modified) {
            array.add((Object)Utils.dateFormater.format(d));
        }
        descr.put((Object)"modified", (Object)array);
        return descr;
    }
}

