/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.gradle.tasks.download.org.apache.http.impl.entity;

import de.undercouch.gradle.tasks.download.org.apache.http.Header;
import de.undercouch.gradle.tasks.download.org.apache.http.HttpEntity;
import de.undercouch.gradle.tasks.download.org.apache.http.HttpException;
import de.undercouch.gradle.tasks.download.org.apache.http.HttpMessage;
import de.undercouch.gradle.tasks.download.org.apache.http.annotation.Contract;
import de.undercouch.gradle.tasks.download.org.apache.http.annotation.ThreadingBehavior;
import de.undercouch.gradle.tasks.download.org.apache.http.entity.BasicHttpEntity;
import de.undercouch.gradle.tasks.download.org.apache.http.entity.ContentLengthStrategy;
import de.undercouch.gradle.tasks.download.org.apache.http.impl.io.ChunkedInputStream;
import de.undercouch.gradle.tasks.download.org.apache.http.impl.io.ContentLengthInputStream;
import de.undercouch.gradle.tasks.download.org.apache.http.impl.io.IdentityInputStream;
import de.undercouch.gradle.tasks.download.org.apache.http.io.SessionInputBuffer;
import de.undercouch.gradle.tasks.download.org.apache.http.util.Args;
import java.io.IOException;

@Deprecated
@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class EntityDeserializer {
    private final ContentLengthStrategy lenStrategy;

    public EntityDeserializer(ContentLengthStrategy lenStrategy) {
        this.lenStrategy = Args.notNull(lenStrategy, "Content length strategy");
    }

    protected BasicHttpEntity doDeserialize(SessionInputBuffer inbuffer, HttpMessage message) throws HttpException, IOException {
        Header contentEncodingHeader;
        BasicHttpEntity entity = new BasicHttpEntity();
        long len = this.lenStrategy.determineLength(message);
        if (len == -2L) {
            entity.setChunked(true);
            entity.setContentLength(-1L);
            entity.setContent(new ChunkedInputStream(inbuffer));
        } else if (len == -1L) {
            entity.setChunked(false);
            entity.setContentLength(-1L);
            entity.setContent(new IdentityInputStream(inbuffer));
        } else {
            entity.setChunked(false);
            entity.setContentLength(len);
            entity.setContent(new ContentLengthInputStream(inbuffer, len));
        }
        Header contentTypeHeader = message.getFirstHeader("Content-Type");
        if (contentTypeHeader != null) {
            entity.setContentType(contentTypeHeader);
        }
        if ((contentEncodingHeader = message.getFirstHeader("Content-Encoding")) != null) {
            entity.setContentEncoding(contentEncodingHeader);
        }
        return entity;
    }

    public HttpEntity deserialize(SessionInputBuffer inbuffer, HttpMessage message) throws HttpException, IOException {
        Args.notNull(inbuffer, "Session input buffer");
        Args.notNull(message, "HTTP message");
        return this.doDeserialize(inbuffer, message);
    }
}

